%--------------------------------------------------------------------------
% File     : ROB012=Eqn3Indn-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Robbins Algebra
% Problem  : If -(a + -b) = c then -(a + -(b + k(a + c))) = c, k=k + 1
% Version  : [Winker, 1990] (equality) axioms : Augmented.
% English  : This is the induction step of an induction proof.

% Refs     : Winker S. (1990), Robbins Algebra: Conditions That Make 
%            a Near-Boolean Algebra Boolean, Journal of Automated 
%            Reasoning 6(4), 465-489.
% Source   : [Winker, 1990]
% Names    : Lemma 3.4 [Winker, 1990]

% Status   : 
% Syntax   : Number of clauses           :   22 (   0 non-Horn)(  10 unit)
%            Number of literals          :   36 (  29 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    9 (   5 constant)
%            Number of variables         :   38 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    7

% Comments : The extra lemma is used in Winker's (1990) proof.
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include axioms for Robbins algebra 
include('Axioms/ROB001-0.ax').
%----Include axioms for numbers in Robbins algebras 
include('Axioms/ROB001-1.ax').
%--------------------------------------------------------------------------
%----This is the extra lemma 
input_clause(lemma_3_3,axiom,
    [--equal(negate(add(X,negate(Y))),Z),
     ++equal(negate(add(Z,negate(add(Y,X)))),X)]).

input_clause(condition,hypothesis,
    [++equal(negate(add(a,negate(b))),c)]).

input_clause(k_an_integer,hypothesis,
    [++positive_integer(k)]).

input_clause(base_step,axiom,
    [++equal(negate(add(a,negate(add(b,multiply(k,add(a,c)))))),c)]).

input_clause(prove_induction_step,theorem,
    [++equal(negate(add(a,negate(add(b,multiply(successor(k),
add(a,c)))))),c)]).
%--------------------------------------------------------------------------
