%--------------------------------------------------------------------------
% File     : ROB009=Eqn2-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Robbins Algebra
% Problem  : If -(a + -(b + c)) = -(b + -(a + c)) then a = b
% Version  : [Winker, 1990] (equality) axioms.
% English  : 

% Refs     : Winker S. (1990), Robbins Algebra: Conditions That Make 
%            a Near-Boolean Algebra Boolean, Journal of Automated 
%            Reasoning 6(4), 465-489.
% Source   : [Winker, 1990]
% Names    : Lemma 3.2 [Winker, 1990]

% Status   : 
% Syntax   : Number of clauses           :   11 (   0 non-Horn)(   6 unit)
%            Number of literals          :   17 (  17 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   3 constant)
%            Number of variables         :   21 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include axioms for Robbins algebra 
include('Axioms/ROB001-0.ax').
%--------------------------------------------------------------------------
input_clause(condition,hypothesis,
    [++equal(negate(add(a,negate(add(b,c)))),negate(add(b,negate(
add(a,c)))))]).

input_clause(prove_result,theorem,
    [--equal(a,b)]).
%--------------------------------------------------------------------------
