%--------------------------------------------------------------------------
% File     : ROB007=RobBool6-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Robbins Algebra
% Problem  : -(a + b)= -b => Boolean
% Version  : [Winker, 1990] (equality) axioms : Augmented.
%            Theorem formulation : Denies Huntington's axiom.
% English  : If there exist a, b such that -(a+b) = -b, then the algebra 
%            is Boolean.

% Refs     : Henkin L., Monk J. and Tarski A. (1971), Cylindrical 
%            Algebras, Part 1, North-Holland, Amsterdam, The Netherlands.
%          : Winker S. (1990), Robbins Algebra: Conditions That Make 
%            a Near-Boolean Algebra Boolean, Journal of Automated 
%            Reasoning 6(4), 465-489.
% Source   : [Winker, 1990]
% Names    : Theorem 1.2 [Winker, 1990]

% Status   : 
% Syntax   : Number of clauses           :   22 (   0 non-Horn)(   9 unit)
%            Number of literals          :   37 (  31 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    7 (   3 constant)
%            Number of variables         :   41 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    7

% Comments : Commutativity, associativity, and Huntington's axiom 
%            axiomatize Boolean algebra.
%          : The extra lemmas are suggested by Winker (1990).
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include axioms for Robbins algebra 
include('Axioms/ROB001-0.ax').
%----Include axioms for numbers in Robbins algebras 
include('Axioms/ROB001-1.ax').
%--------------------------------------------------------------------------
input_clause(absorbtion,axiom,
    [--equal(add(X,Y),Y)]).

input_clause(corollary_3_9_1,axiom,
    [--equal(negate(add(X,negate(Y))),negate(Y)),
     ++equal(add(Y,multiply(successor(successor(one)),add(X,negate(
add(X,negate(Y)))))),add(Y,multiply(successor(one),add(X,negate(
add(X,negate(Y)))))))]).

input_clause(corollary_3_9_2,axiom,
    [--equal(negate(add(negate(Y),negate(add(X,negate(Y))))),X),
     ++equal(add(Y,multiply(successor(successor(one)),add(X,negate(
add(X,negate(Y)))))),add(Y,multiply(successor(one),add(X,negate(
add(X,negate(Y)))))))]).

%----Clauses fom the theorem 
input_clause(condition,hypothesis,
    [++equal(negate(add(a,b)),negate(b))]).

input_clause(prove_huntingtons_axiom,theorem,
    [--equal(add(negate(add(a,negate(b))),negate(add(negate(a),
negate(b)))),b)]).
%--------------------------------------------------------------------------
