%--------------------------------------------------------------------------
% File     : ROB007=RobBool6-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Robbins Algebra
% Problem  : -(a + b)= -b => Boolean
% Version  : [Winker, 1990] (equality) axioms.
%            Theorem formulation : Denies Huntington's axiom, double 
%            negation, and idempotence.
% English  : If there exist a, b such that -(a+b) = -b, then the algebra 
%            is Boolean.

% Refs     : Henkin L., Monk J. and Tarski A. (1971), Cylindrical 
%            Algebras, Part 1, North-Holland, Amsterdam, The Netherlands.
%          : Winker S. (1990), Robbins Algebra: Conditions That Make 
%            a Near-Boolean Algebra Boolean, Journal of Automated 
%            Reasoning 6(4), 465-489.
% Source   : [Winker, 1990]
% Names    : Theorem 1.2 [Winker, 1990]

% Status   : 
% Syntax   : Number of clauses           :   13 (   0 non-Horn)(   8 unit)
%            Number of literals          :   19 (  19 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   3 constant)
%            Number of variables         :   22 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : Commutativity, associativity, and Huntington's axiom 
%            axiomatize Boolean algebra.
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include axioms for Robbins algebra 
include('Axioms/ROB001-0.ax').
%--------------------------------------------------------------------------
input_clause(condition,hypothesis,
    [++equal(negate(add(a,b)),negate(b))]).

input_clause(prove_huntingtons_axiom,theorem,
    [--equal(add(negate(add(a,negate(b))),negate(add(negate(a),
negate(b)))),b)]).

input_clause(prove_double_negation,theorem,
    [--equal(negate(negate(r)),r)]).

input_clause(prove_idempotence,theorem,
    [--equal(add(X,X),X)]).
%--------------------------------------------------------------------------
