%--------------------------------------------------------------------------
% File     : ROB006=RobBool5-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Robbins Algebra
% Problem  : c + d=d => Boolean
% Version  : [Winker, 1990] (equality) axioms : Augmented.
%            Theorem formulation : Denies Huntington's axiom.
% English  : If there are elements c and d such that c+d=d, then the 
%            algebra is Boolean.

% Refs     : Henkin L., Monk J. and Tarski A. (1971), Cylindrical 
%            Algebras, Part 1, North-Holland, Amsterdam, The Netherlands.
%          : Winker S. (1990), Robbins Algebra: Conditions That Make 
%            a Near-Boolean Algebra Boolean, Journal of Automated 
%            Reasoning 6(4), 465-489.
%          : Wos, L (1992), An Opportunity to Test Your Skills-and the 
%            Power of Your Automated Reasoning Program, Association for 
%            Automated Reasoning Newsletter 21, 10-11.
% Source   : [Wos, 1992]
% Names    : Theorem 1.1 [Winker, 1990]

% Status   : 
% Syntax   : Number of clauses           :   23 (   0 non-Horn)(   9 unit)
%            Number of literals          :   40 (  33 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    9 (   5 constant)
%            Number of variables         :   43 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    8

% Comments : Commutativity, associativity, and Huntington's axiom 
%            axiomatize Boolean algebra.
%          : The extra lemmas are suggested by Winker (1990).
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include axioms for Robbins algebra 
include('Axioms/ROB001-0.ax').
%----Include axioms for Robbins algebra numbers 
include('Axioms/ROB001-1.ax').
%--------------------------------------------------------------------------
%----The following are extra lemmas 
input_clause(idempotence,axiom,
    [--equal(add(X,X),X)]).

input_clause(corollary_3_7,axiom,
    [--equal(negate(add(X,Y)),negate(Y)),
     --positive_integer(V2),
     ++equal(negate(add(Y,multiply(V2,add(X,negate(add(X,
negate(Y))))))),negate(Y))]).

input_clause(corollary_3_9_1,axiom,
    [--equal(negate(add(X,negate(Y))),negate(Y)),
     ++equal(add(Y,multiply(successor(successor(one)),add(X,negate(
add(X,negate(Y)))))),add(Y,multiply(successor(one),add(X,negate(
add(X,negate(Y)))))))]).

input_clause(corollary_3_9_2,axiom,
    [--equal(negate(add(negate(Y),negate(add(X,negate(Y))))),X),
     ++equal(add(Y,multiply(successor(successor(one)),add(X,negate(
add(X,negate(Y)))))),add(Y,multiply(successor(one),add(X,negate(
add(X,negate(Y)))))))]).

%----Hypothesis of the theorem 
input_clause(absorbtion,hypothesis,
    [++equal(add(c,d),d)]).

input_clause(prove_huntingtons_axiom,theorem,
    [--equal(add(negate(add(a,negate(b))),negate(add(negate(a),
negate(b)))),b)]).
%--------------------------------------------------------------------------
