%--------------------------------------------------------------------------
% File     : ROB006=RobBool5-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Robbins Algebra
% Problem  : c + d=d => Boolean
% Version  : [Winker, 1990] (equality) axioms.
%            Theorem formulation : Denies idempotence.
% English  : If there are elements c and d such that c+d=d, then the 
%            algebra is Boolean.

% Refs     : Henkin L., Monk J. and Tarski A. (1971), Cylindrical 
%            Algebras, Part 1, North-Holland, Amsterdam, The Netherlands.
%          : Winker S. (1990), Robbins Algebra: Conditions That Make 
%            a Near-Boolean Algebra Boolean, Journal of Automated 
%            Reasoning 6(4), 465-489.
%          : Wos, L (1992), An Opportunity to Test Your Skills-and the 
%            Power of Your Automated Reasoning Program, Association for 
%            Automated Reasoning Newsletter 21, 10-11.
% Source   : [Wos, 1992]
% Names    : Theorem 1.1 [Winker, 1990]

% Status   : 
% Syntax   : Number of clauses           :   11 (   0 non-Horn)(   6 unit)
%            Number of literals          :   17 (  17 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :   22 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : Commutativity, associativity, and Huntington's axiom 
%            axiomatize Boolean algebra.
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include axioms for Robbins algebra 
include('Axioms/ROB001-0.ax').
%--------------------------------------------------------------------------
input_clause(absorbtion,hypothesis,
    [++equal(add(c,d),d)]).

input_clause(prove_idempotence,theorem,
    [--equal(add(X,X),X)]).
%--------------------------------------------------------------------------
