%--------------------------------------------------------------------------
% File     : ROB005=RobBool4-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Robbins Algebra
% Problem  : c + c=c => Boolean
% Version  : [Winker, 1990] (equality) axioms.
% English  : If there is an element c such that c+c=c, then the algebra 
%            is Boolean.

% Refs     : Henkin L., Monk J. and Tarski A. (1971), Cylindrical 
%            Algebras, Part 1, North-Holland, Amsterdam, The Netherlands.
%          : Winker S. (1990), Robbins Algebra: Conditions That Make 
%            a Near-Boolean Algebra Boolean, Journal of Automated 
%            Reasoning 6(4), 465-489.
%          : Overbeek R. (1990), ATP competition announced at CADE-10.
%          : Lusk E., and Wos L. (1992), Benchmark Problems in Which 
%            Equality Plays the Major Role, In Kapur D. (Ed.), Proceedings 
%            of the 11th International Conference on Automated Deduction 
%            (Saratoga Springs, NY, 1992), (Lecture Notes in Artificial 
%            Intelligence 607), Springer-Verlag, New York, NY, 781-785.
%          : Overbeek R. (1993), The CADE-11 Competitions: A Personal 
%            View, Journal of Automated Reasoning 11(3), 315-316.
%          : Lusk E.L., McCune W.W. (1993), Uniform Strategies: The 
%            CADE-11 Theorem Proving Contest, Journal of Automated 
%            Reasoning 11(3), 317-331.
%          : Zhang H. (1993), Automated Proofs of Equality Problems 
%            in Overbeek's Competition, Journal of Automated Reasoning 
%            11(3), 333-351.
% Source   : [Overbeek, 1990]
% Names    : Overbeek Competition Eq-2 [Overbeek, 1990]
%          : Lemma 2.4 [Winker, 1990]
%          : RA3 [Lusk & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :   11 (   0 non-Horn)(   6 unit)
%            Number of literals          :   17 (  17 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   3 constant)
%            Number of variables         :   21 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : Commutativity, associativity, and Huntington's axiom 
%            axiomatize Boolean algebra.
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include axioms for Robbins algebra 
include('Axioms/ROB001-0.ax').
%--------------------------------------------------------------------------
input_clause(idempotence,hypothesis,
    [++equal(add(c,c),c)]).

input_clause(prove_huntingtons_axiom,theorem,
    [--equal(add(negate(add(a,negate(b))),negate(add(negate(a),
negate(b)))),b)]).
%--------------------------------------------------------------------------
