%--------------------------------------------------------------------------
% File     : ROB004=RobBool3-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Robbins Algebra
% Problem  : c = -d, c + d=d, and c + c=c => Boolean
% Version  : [Winker, 1990] (equality) axioms.
% English  : If there exist c, d such that c = -d, c+d=d, and c+c=c, then 
%            the algebra is Boolean.

% Refs     : Henkin L., Monk J. and Tarski A. (1971), Cylindrical 
%            Algebras, Part 1, North-Holland, Amsterdam, The Netherlands.
%          : Winker S. (1990), Robbins Algebra: Conditions That Make 
%            a Near-Boolean Algebra Boolean, Journal of Automated 
%            Reasoning 6(4), 465-489.
% Source   : [Winker, 1990]
% Names    : Lemma 2.3 [Winker, 1990]

% Status   : 
% Syntax   : Number of clauses           :   13 (   0 non-Horn)(   8 unit)
%            Number of literals          :   19 (  19 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    6 (   4 constant)
%            Number of variables         :   21 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : Commutativity, associativity, and Huntington's axiom 
%            axiomatize Boolean algebra.
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include axioms for Robbins algebra 
include('Axioms/ROB001-0.ax').
%--------------------------------------------------------------------------
input_clause(negate_d_is_c,hypothesis,
    [++equal(negate(d),c)]).

input_clause(c_plus_d_is_d,hypothesis,
    [++equal(add(c,d),d)]).

input_clause(c_plus_c_is_c,hypothesis,
    [++equal(add(c,c),c)]).

input_clause(prove_huntingtons_axiom,theorem,
    [--equal(add(negate(add(a,negate(b))),negate(add(negate(a),
negate(b)))),b)]).
%--------------------------------------------------------------------------
