%--------------------------------------------------------------------------
% File     : ROB003=RobBool2-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Robbins Algebra
% Problem  : X + c=c => Boolean
% Version  : [Winker, 1990] (equality) axioms.
% English  : If there exists c such that X+c=c, then the algebra 
%            is Boolean.

% Refs     : Henkin L., Monk J. and Tarski A. (1971), Cylindrical 
%            Algebras, Part 1, North-Holland, Amsterdam, The Netherlands.
%          : Winker S. (1990), Robbins Algebra: Conditions That Make 
%            a Near-Boolean Algebra Boolean, Journal of Automated 
%            Reasoning 6(4), 465-489.
%          : Lusk E., and Wos L. (1992), Benchmark Problems in Which 
%            Equality Plays the Major Role, In Kapur D. (Ed.), Proceedings 
%            of the 11th International Conference on Automated Deduction 
%            (Saratoga Springs, NY, 1992), (Lecture Notes in Artificial 
%            Intelligence 607), Springer-Verlag, New York, NY, 781-785.
% Source   : [OTTER]
% Names    : Lemma 2.2 [Winker, 1990]
%          : RA1 [Lusk & Wos, 1992]
%          : robbins.in [OTTER]

% Status   : 
% Syntax   : Number of clauses           :   11 (   0 non-Horn)(   6 unit)
%            Number of literals          :   17 (  17 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   3 constant)
%            Number of variables         :   22 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : Commutativity, associativity, and Huntington's axiom 
%            axiomatize Boolean algebra.
%          : In Overbeek's version, the hypothesis is slightly 
%            different : ...an element c such that c+c=c, then... Mail 
%            from McCune says that this is a simpler problem.
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include axioms for Robbins algebra 
include('Axioms/ROB001-0.ax').
%--------------------------------------------------------------------------
input_clause(there_exists_a_constant,hypothesis,
    [++equal(add(X,c),c)]).

input_clause(prove_huntingtons_axiom,theorem,
    [--equal(add(negate(add(a,negate(b))),negate(add(negate(a),
negate(b)))),b)]).
%--------------------------------------------------------------------------
