%--------------------------------------------------------------------------
% File     : ROB001=RobBool-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Robbins Algebra
% Problem  : Is every Robbins algebra Boolean?
% Version  : [Winker, 1990] (equality) axioms.
% English  : 

% Refs     : Henkin L., Monk J. and Tarski A. (1971), Cylindrical 
%            Algebras, Part 1, North-Holland, Amsterdam, The Netherlands.
%          : Winker S. (1990), Robbins Algebra: Conditions That Make 
%            a Near-Boolean Algebra Boolean, Journal of Automated 
%            Reasoning 6(4), 465-489.
% Source   : [TPTP]
% Names    : 

% Status   : open
% Syntax   : Number of clauses           :   10 (   0 non-Horn)(   5 unit)
%            Number of literals          :   16 (  16 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :   21 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : Commutativity, associativity, and Huntington's axiom 
%            axiomatize Boolean algebra.
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include axioms for Robbins algebra 
include('Axioms/ROB001-0.ax').
%--------------------------------------------------------------------------
input_clause(prove_huntingtons_axiom,theorem,
    [--equal(add(negate(add(a,negate(b))),negate(add(negate(a),
negate(b)))),b)]).
%--------------------------------------------------------------------------
