%--------------------------------------------------------------------------
% File     : RNG041=RngEqn4-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : Unknown
% Version  : [Wos, 1965] axioms.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Problem 30 [Wos, 1965]
%          : wos30 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   41 (   2 non-Horn)(  14 unit)
%            Number of literals          :   97 (  30 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    8 (   4 constant)
%            Number of variables         :  123 (   2 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : These are the same axioms as in [McCharen, et al., 1976].
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include ring theory axioms 
include('Axioms/RNG001-0.ax').
%----Include substitution axioms 
include('Axioms/RNG001-0.eq').
%--------------------------------------------------------------------------
input_clause(h_substitution,axiom,
    [--equal(A,B),
     ++equal(h(A),h(B))]).

input_clause(multiplicative_identity1,hypothesis,
    [++product(additive_identity,A,additive_identity)]).

input_clause(multiplicative_identity2,hypothesis,
    [++product(A,additive_identity,additive_identity)]).

input_clause(right_multiplicative_identity,hypothesis,
    [++product(A,multiplicative_identity,A)]).

input_clause(left_multiplicative_identity,hypothesis,
    [++product(multiplicative_identity,A,A)]).

input_clause(clause41,hypothesis,
    [++product(A,h(A),multiplicative_identity),
     ++equal(A,additive_identity)]).

input_clause(clause42,hypothesis,
    [++product(h(A),A,multiplicative_identity),
     ++equal(A,additive_identity)]).

input_clause(a_times_b,theorem,
    [++product(a,b,additive_identity)]).

input_clause(a_not_additive_identity,theorem,
    [--equal(a,additive_identity)]).

input_clause(prove_b_is_additive_identity,theorem,
    [--equal(b,additive_identity)]).
%--------------------------------------------------------------------------
