%--------------------------------------------------------------------------
% File     : RNG040=RngEqn3-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : Ring property 4
% Version  : [Wos, 1965] axioms : Incomplete.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Problem 29 [Wos, 1965]
%          : wos29 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   40 (   2 non-Horn)(  14 unit)
%            Number of literals          :   89 (  28 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   12 (   8 constant)
%            Number of variables         :  110 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : These are the same axioms as in [McCharen, et al., 1976].
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include ring theory axioms 
%include('Axioms/RNG001-0.ax').
%----Include substitution axioms 
include('Axioms/RNG001-0.eq').
%--------------------------------------------------------------------------
input_clause(additive_identity1,axiom,
    [++sum(additive_identity,X,X)]).

input_clause(additive_identity2,axiom,
    [++sum(X,additive_identity,X)]).

input_clause(closure_of_multiplication,axiom,
    [++product(X,Y,multiply(X,Y))]).

input_clause(closure_of_addition,axiom,
    [++sum(X,Y,add(X,Y))]).

input_clause(additive_inverse1,axiom,
    [++sum(additive_inverse(X),X,additive_identity)]).

input_clause(additive_inverse2,axiom,
    [++sum(X,additive_inverse(X),additive_identity)]).

input_clause(associativity_of_addition1,axiom,
    [--sum(X,Y,U),
     --sum(Y,Z,V),
     --sum(U,Z,W),
     ++sum(X,V,W)]).

input_clause(associativity_of_addition2,axiom,
    [--sum(X,Y,U),
     --sum(Y,Z,V),
     --sum(X,V,W),
     ++sum(U,Z,W)]).

input_clause(commutativity_of_addition,axiom,
    [--sum(X,Y,Z),
     ++sum(Y,X,Z)]).

input_clause(associativity_of_multiplication1,axiom,
    [--product(X,Y,U),
     --product(Y,Z,V),
     --product(U,Z,W),
     ++product(X,V,W)]).

input_clause(associativity_of_multiplication2,axiom,
    [--product(X,Y,U),
     --product(Y,Z,V),
     --product(X,V,W),
     ++product(U,Z,W)]).

input_clause(distributivity1,axiom,
    [--product(X,Y,V1),
     --product(X,Z,V2),
     --sum(Y,Z,V3),
     --product(X,V3,V4),
     ++sum(V1,V2,V4)]).

input_clause(distributivity2,axiom,
    [--product(X,Y,V1),
     --product(X,Z,V2),
     --sum(Y,Z,V3),
     --sum(V1,V2,V4),
     ++product(X,V3,V4)]).

%input_clause(distributivity3,axiom,
%    [--product(Y,X,V1),
%     --product(Z,X,V2),
%     --sum(Y,Z,V3),
%     --product(V3,X,V4),
%     ++sum(V1,V2,V4)]).

%input_clause(distributivity4,axiom,
%    [--product(Y,X,V1),
%     --product(Z,X,V2),
%     --sum(Y,Z,V3),
%     --sum(V1,V2,V4),
%     ++product(V3,X,V4)]).

%-----Equality axioms for operators 
input_clause(addition_is_well_defined,axiom,
    [--sum(X,Y,U),
     --sum(X,Y,V),
     ++equal(U,V)]).

input_clause(multiplication_is_well_defined,axiom,
    [--product(X,Y,U),
     --product(X,Y,V),
     ++equal(U,V)]).

input_clause(right_multiplicative_identity,hypothesis,
    [++product(A,multiplicative_identity,A)]).

input_clause(left_multiplicative_identity,hypothesis,
    [++product(multiplicative_identity,A,A)]).

input_clause(clause30,hypothesis,
    [++product(A,h(A),multiplicative_identity),
     ++equal(A,additive_identity)]).

input_clause(clause31,hypothesis,
    [++product(h(A),A,multiplicative_identity),
     ++equal(A,additive_identity)]).

input_clause(product_symmetry,hypothesis,
    [--product(A,B,C),
     ++product(B,A,C)]).

input_clause(h_substitution,hypothesis,
    [--equal(A,B),
     ++equal(h(A),h(B))]).

input_clause(b_plus_c,theorem,
    [++sum(b,c,d)]).

input_clause(d_plus_a,theorem,
    [++product(d,a,additive_identity)]).

input_clause(b_plus_a,theorem,
    [++product(b,a,l)]).

input_clause(c_plus_a,theorem,
    [++product(c,a,n)]).

input_clause(prove_equation,theorem,
    [--sum(l,n,additive_identity)]).
%--------------------------------------------------------------------------
