%--------------------------------------------------------------------------
% File     : RNG040=RngEqn3-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : Ring property 4
% Version  : [Wos, 1965] axioms : Incomplete > Augmented > Complete.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [SPRFN]
% Names    : Problem 29 [Wos, 1965]

% Status   : 
% Syntax   : Number of clauses           :   42 (   2 non-Horn)(  14 unit)
%            Number of literals          :   99 (  28 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   12 (   8 constant)
%            Number of variables         :  124 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : These are the same axioms as in [McCharen, et al., 1976].
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include ring theory axioms 
include('Axioms/RNG001-0.ax').
%----Include substitution axioms 
include('Axioms/RNG001-0.eq').
%--------------------------------------------------------------------------
input_clause(right_multiplicative_identity,hypothesis,
    [++product(A,multiplicative_identity,A)]).

input_clause(left_multiplicative_identity,hypothesis,
    [++product(multiplicative_identity,A,A)]).

input_clause(clause30,hypothesis,
    [++product(A,h(A),multiplicative_identity),
     ++equal(A,additive_identity)]).

input_clause(clause31,hypothesis,
    [++product(h(A),A,multiplicative_identity),
     ++equal(A,additive_identity)]).

input_clause(product_symmetry,hypothesis,
    [--product(A,B,C),
     ++product(B,A,C)]).

input_clause(h_substitution,hypothesis,
    [--equal(A,B),
     ++equal(h(A),h(B))]).

input_clause(b_plus_c,theorem,
    [++sum(b,c,d)]).

input_clause(d_plus_a,theorem,
    [++product(d,a,additive_identity)]).

input_clause(b_plus_a,theorem,
    [++product(b,a,l)]).

input_clause(c_plus_a,theorem,
    [++product(c,a,n)]).

input_clause(prove_equation,theorem,
    [--sum(l,n,additive_identity)]).
%--------------------------------------------------------------------------
