%--------------------------------------------------------------------------
% File     : RNG039=RngEqn2-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : Ring property 2
% Version  : [Wos, 1965] axioms : Reduced > Incomplete.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Problem 28 [Wos, 1965]
%          : wos28 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   74 (   0 non-Horn)(  50 unit)
%            Number of literals          :  129 (  28 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    7 (   5 constant)
%            Number of variables         :  139 (   3 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : There is no additive inverse in this problem.
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
%include('Axioms/EQU001-0.ax').
%----Include ring theory axioms 
%include('Axioms/RNG001-0.ax').
%----Include substitution axioms 
%include('Axioms/RNG001-0.eq').
%--------------------------------------------------------------------------
input_clause(reflexivity,axiom,
    [++equal(X,X)]).

%input_clause(symmetry,axiom,
%    [--equal(X,Y),
%     ++equal(Y,X)]).

input_clause(transitivity,axiom,
    [--equal(X,Y),
     --equal(Y,Z),
     ++equal(X,Z)]).

input_clause(additive_identity1,axiom,
    [++sum(additive_identity,X,X)]).

input_clause(additive_identity2,axiom,
    [++sum(X,additive_identity,X)]).

input_clause(closure_of_multiplication,axiom,
    [++product(X,Y,multiply(X,Y))]).

input_clause(closure_of_addition,axiom,
    [++sum(X,Y,add(X,Y))]).

%input_clause(additive_inverse1,axiom,
%    [++sum(additive_inverse(X),X,additive_identity)]).

%input_clause(additive_inverse2,axiom,
%    [++sum(X,additive_inverse(X),additive_identity)]).

input_clause(associativity_of_addition1,axiom,
    [--sum(X,Y,U),
     --sum(Y,Z,V),
     --sum(U,Z,W),
     ++sum(X,V,W)]).

input_clause(associativity_of_addition2,axiom,
    [--sum(X,Y,U),
     --sum(Y,Z,V),
     --sum(X,V,W),
     ++sum(U,Z,W)]).

input_clause(commutativity_of_addition,axiom,
    [--sum(X,Y,Z),
     ++sum(Y,X,Z)]).

input_clause(associativity_of_multiplication1,axiom,
    [--product(X,Y,U),
     --product(Y,Z,V),
     --product(U,Z,W),
     ++product(X,V,W)]).

input_clause(associativity_of_multiplication2,axiom,
    [--product(X,Y,U),
     --product(Y,Z,V),
     --product(X,V,W),
     ++product(U,Z,W)]).

input_clause(distributivity1,axiom,
    [--product(X,Y,V1),
     --product(X,Z,V2),
     --sum(Y,Z,V3),
     --product(X,V3,V4),
     ++sum(V1,V2,V4)]).

input_clause(distributivity2,axiom,
    [--product(X,Y,V1),
     --product(X,Z,V2),
     --sum(Y,Z,V3),
     --sum(V1,V2,V4),
     ++product(X,V3,V4)]).

input_clause(distributivity3,axiom,
    [--product(Y,X,V1),
     --product(Z,X,V2),
     --sum(Y,Z,V3),
     --product(V3,X,V4),
     ++sum(V1,V2,V4)]).

input_clause(distributivity4,axiom,
    [--product(Y,X,V1),
     --product(Z,X,V2),
     --sum(Y,Z,V3),
     --sum(V1,V2,V4),
     ++product(V3,X,V4)]).

input_clause(multiplicative_identity1,axiom,
    [++product(additive_identity,X,additive_identity)]).

input_clause(multiplicative_identity2,axiom,
    [++product(X,additive_identity,additive_identity)]).

%-----Equality axioms for operators 
input_clause(addition_is_well_defined,axiom,
    [--sum(X,Y,U),
     --sum(X,Y,V),
     ++equal(U,V)]).

input_clause(multiplication_is_well_defined,axiom,
    [--product(X,Y,U),
     --product(X,Y,V),
     ++equal(U,V)]).

%input_clause(additive_inverse_substitution,axiom,
%    [--equal(X,Y),
%     ++equal(additive_inverse(X),additive_inverse(Y))]).

input_clause(add_substitution1,axiom,
    [--equal(X,Y),
     ++equal(add(X,W),add(Y,W))]).

input_clause(add_substitution2,axiom,
    [--equal(X,Y),
     ++equal(add(W,X),add(W,Y))]).

input_clause(sum_substitution1,axiom,
    [--equal(X,Y),
     --sum(X,W,Z),
     ++sum(Y,W,Z)]).

input_clause(sum_substitution2,axiom,
    [--equal(X,Y),
     --sum(W,X,Z),
     ++sum(W,Y,Z)]).

input_clause(sum_substitution3,axiom,
    [--equal(X,Y),
     --sum(W,Z,X),
     ++sum(W,Z,Y)]).

input_clause(multiply_substitution1,axiom,
    [--equal(X,Y),
     ++equal(multiply(X,W),multiply(Y,W))]).

input_clause(multiply_substitution2,axiom,
    [--equal(X,Y),
     ++equal(multiply(W,X),multiply(W,Y))]).

input_clause(product_substitution1,axiom,
    [--equal(X,Y),
     --product(X,W,Z),
     ++product(Y,W,Z)]).

input_clause(product_substitution2,axiom,
    [--equal(X,Y),
     --product(W,X,Z),
     ++product(W,Y,Z)]).

input_clause(product_substitution3,axiom,
    [--equal(X,Y),
     --product(W,Z,X),
     ++product(W,Z,Y)]).

input_clause(sum_left_cancellation,axiom,
    [--sum(A,B,C),
     --sum(D,B,C),
     ++equal(D,A)]).

input_clause(sum_right_concellation,axiom,
    [--sum(A,B,C),
     --sum(A,D,C),
     ++equal(D,B)]).

input_clause(absorbtion1,axiom,
    [++sum(A,add(A,B),B)]).

input_clause(absorbtion2,axiom,
    [++sum(add(A,B),B,A)]).

input_clause(clause32,axiom,
    [++sum(A,A,additive_identity)]).

input_clause(clause33,axiom,
    [++equal(add(A,additive_identity),A)]).

input_clause(clause34,axiom,
    [++equal(add(A,A),additive_identity)]).

input_clause(clause35,axiom,
    [++equal(multiply(A,A),A)]).

input_clause(clause36,axiom,
    [++equal(multiply(a,b),c)]).

input_clause(clause37,axiom,
    [++equal(multiply(b,a),d)]).

input_clause(clause38,axiom,
    [++sum(A,B,add(B,A))]).

input_clause(clause39,axiom,
    [++product(a,c,c)]).

input_clause(clause40,axiom,
    [++product(b,d,d)]).

input_clause(clause41,axiom,
    [++product(c,b,c)]).

input_clause(clause42,axiom,
    [++product(d,a,d)]).

input_clause(clause43,axiom,
    [++product(A,multiply(A,B),multiply(A,B))]).

input_clause(clause44,axiom,
    [++product(a,multiply(b,A),multiply(B,A))]).

input_clause(clause45,axiom,
    [++product(a,b,multiply(c,b))]).

input_clause(clause46,axiom,
    [++product(a,multiply(b,c),c)]).

input_clause(clause47,axiom,
    [++product(b,multiply(a,A),multiply(d,A))]).

input_clause(clause48,axiom,
    [++product(b,a,multiply(d,a))]).

input_clause(clause49,axiom,
    [++product(b,multiply(a,d),d)]).

input_clause(clause50,axiom,
    [++product(b,c,multiply(d,b))]).

input_clause(clause51,axiom,
    [++product(a,d,multiply(c,a))]).

input_clause(clause52,axiom,
    [++product(multiply(A,B),B,multiply(A,B))]).

input_clause(clause53,axiom,
    [++product(multiply(A,a),b,multiply(A,c))]).

input_clause(clause54,axiom,
    [++product(a,b,multiply(a,c))]).

input_clause(clause55,axiom,
    [++product(multiply(c,a),b,c)]).

input_clause(clause56,axiom,
    [++product(d,b,multiply(b,c))]).

input_clause(clause57,axiom,
    [++product(multiply(A,b),a,multiply(A,d))]).

input_clause(clause58,axiom,
    [++product(b,a,multiply(b,d))]).

input_clause(clause59,axiom,
    [++product(multiply(d,b),a,d)]).

input_clause(clause60,axiom,
    [++product(c,a,multiply(a,d))]).

input_clause(clause63,axiom,
    [++product(a,add(b,a),add(c,a))]).

input_clause(clause64,axiom,
    [++product(a,add(a,b),add(a,c))]).

input_clause(clause65,axiom,
    [++product(b,add(a,b),add(d,b))]).

input_clause(clause66,axiom,
    [++product(b,add(b,a),add(b,d))]).

input_clause(clause67,axiom,
    [++product(add(a,b),b,add(c,b))]).

input_clause(clause68,axiom,
    [++product(add(b,a),b,add(b,c))]).

input_clause(clause69,axiom,
    [++product(add(b,a),a,add(d,a))]).

input_clause(clause70,axiom,
    [++product(add(a,b),a,add(a,d))]).

input_clause(clause71,axiom,
    [++product(A,A,A)]).

input_clause(a_times_b,theorem,
    [++product(a,b,c)]).

input_clause(b_times_a,theorem,
    [++product(b,a,d)]).

input_clause(prove_c_equals_d,theorem,
    [--equal(c,d)]).
%--------------------------------------------------------------------------
