%--------------------------------------------------------------------------
% File     : RNG039=RngEqn2-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : Ring property 2
% Version  : [Wos, 1965] axioms.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [SPRFN]
% Names    : Problem 28 [Wos, 1965]

% Status   : 
% Syntax   : Number of clauses           :   74 (   0 non-Horn)(  50 unit)
%            Number of literals          :  127 (  30 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    8 (   5 constant)
%            Number of variables         :  135 (   1 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : These are the same axioms as in [McCharen, et al., 1976].
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include ring theory axioms 
include('Axioms/RNG001-0.ax').
%----Include substitution axioms 
include('Axioms/RNG001-0.eq').
%--------------------------------------------------------------------------
input_clause(absorbtion1,axiom,
    [++sum(A,add(A,B),B)]).

input_clause(absorbtion2,axiom,
    [++sum(add(A,B),B,A)]).

input_clause(clause32,axiom,
    [++sum(A,A,additive_identity)]).

input_clause(clause33,axiom,
    [++equal(add(A,additive_identity),A)]).

input_clause(clause34,axiom,
    [++equal(add(A,A),additive_identity)]).

input_clause(clause35,axiom,
    [++equal(multiply(A,A),A)]).

input_clause(clause36,axiom,
    [++equal(multiply(a,b),c)]).

input_clause(clause37,axiom,
    [++equal(multiply(b,a),d)]).

input_clause(clause38,axiom,
    [++sum(A,B,add(B,A))]).

input_clause(clause39,axiom,
    [++product(a,c,c)]).

input_clause(clause40,axiom,
    [++product(b,d,d)]).

input_clause(clause41,axiom,
    [++product(c,b,c)]).

input_clause(clause42,axiom,
    [++product(d,a,d)]).

input_clause(clause43,axiom,
    [++product(A,multiply(A,B),multiply(A,B))]).

input_clause(clause44,axiom,
    [++product(a,multiply(b,A),multiply(B,A))]).

input_clause(clause45,axiom,
    [++product(a,b,multiply(c,b))]).

input_clause(clause46,axiom,
    [++product(a,multiply(b,c),c)]).

input_clause(clause47,axiom,
    [++product(b,multiply(a,A),multiply(d,A))]).

input_clause(clause48,axiom,
    [++product(b,a,multiply(d,a))]).

input_clause(clause49,axiom,
    [++product(b,multiply(a,d),d)]).

input_clause(clause50,axiom,
    [++product(b,c,multiply(d,b))]).

input_clause(clause51,axiom,
    [++product(a,d,multiply(c,a))]).

input_clause(clause52,axiom,
    [++product(multiply(A,B),B,multiply(A,B))]).

input_clause(clause53,axiom,
    [++product(multiply(A,a),b,multiply(A,c))]).

input_clause(clause54,axiom,
    [++product(a,b,multiply(a,c))]).

input_clause(clause55,axiom,
    [++product(multiply(c,a),b,c)]).

input_clause(clause56,axiom,
    [++product(d,b,multiply(b,c))]).

input_clause(clause57,axiom,
    [++product(multiply(A,b),a,multiply(A,d))]).

input_clause(clause58,axiom,
    [++product(b,a,multiply(b,d))]).

input_clause(clause59,axiom,
    [++product(multiply(d,b),a,d)]).

input_clause(clause60,axiom,
    [++product(c,a,multiply(a,d))]).

input_clause(clause63,axiom,
    [++product(a,add(b,a),add(c,a))]).

input_clause(clause64,axiom,
    [++product(a,add(a,b),add(a,c))]).

input_clause(clause65,axiom,
    [++product(b,add(a,b),add(d,b))]).

input_clause(clause66,axiom,
    [++product(b,add(b,a),add(b,d))]).

input_clause(clause67,axiom,
    [++product(add(a,b),b,add(c,b))]).

input_clause(clause68,axiom,
    [++product(add(b,a),b,add(b,c))]).

input_clause(clause69,axiom,
    [++product(add(b,a),a,add(d,a))]).

input_clause(clause70,axiom,
    [++product(add(a,b),a,add(a,d))]).

input_clause(clause71,axiom,
    [++product(A,A,A)]).

input_clause(a_times_b,theorem,
    [++product(a,b,c)]).

input_clause(b_times_a,theorem,
    [++product(b,a,d)]).

input_clause(prove_c_equals_d,theorem,
    [--equal(c,d)]).
%--------------------------------------------------------------------------
