%--------------------------------------------------------------------------
% File     : RNG038=RngEqn1-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : Ring property 1
% Version  : [Wos, 1965] axioms : Reduced > Incomplete.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Problem 27 [Wos, 1965]
%          : wos27 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   30 (   0 non-Horn)(   9 unit)
%            Number of literals          :   79 (  17 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    7 (   3 constant)
%            Number of variables         :  105 (   2 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Don't Include ring theory axioms 
%include('Axioms/RNG001-0.ax').
%----Don't include substitution axioms 
%include('Axioms/RNG001-0.eq').
%--------------------------------------------------------------------------
%----Not used in this version 
%input_clause(additive_identity1,axiom,
%    [++sum(additive_identity,X,X)]).

input_clause(additive_identity2,axiom,
    [++sum(X,additive_identity,X)]).

input_clause(closure_of_multiplication,axiom,
    [++product(X,Y,multiply(X,Y))]).

input_clause(closure_of_addition,axiom,
    [++sum(X,Y,add(X,Y))]).

%----Not used in this version 
%input_clause(additive_inverse1,axiom,
%    [++sum(additive_inverse(X),X,additive_identity)]).

input_clause(additive_inverse2,axiom,
    [++sum(X,additive_inverse(X),additive_identity)]).

input_clause(associativity_of_addition1,axiom,
    [--sum(X,Y,U),
     --sum(Y,Z,V),
     --sum(U,Z,W),
     ++sum(X,V,W)]).

input_clause(associativity_of_addition2,axiom,
    [--sum(X,Y,U),
     --sum(Y,Z,V),
     --sum(X,V,W),
     ++sum(U,Z,W)]).

input_clause(commutativity_of_addition,axiom,
    [--sum(X,Y,Z),
     ++sum(Y,X,Z)]).

input_clause(associativity_of_multiplication1,axiom,
    [--product(X,Y,U),
     --product(Y,Z,V),
     --product(U,Z,W),
     ++product(X,V,W)]).

input_clause(associativity_of_multiplication2,axiom,
    [--product(X,Y,U),
     --product(Y,Z,V),
     --product(X,V,W),
     ++product(U,Z,W)]).

input_clause(distributivity1,axiom,
    [--product(X,Y,V1),
     --product(X,Z,V2),
     --sum(Y,Z,V3),
     --product(X,V3,V4),
     ++sum(V1,V2,V4)]).

input_clause(distributivity2,axiom,
    [--product(X,Y,V1),
     --product(X,Z,V2),
     --sum(Y,Z,V3),
     --sum(V1,V2,V4),
     ++product(X,V3,V4)]).

input_clause(distributivity3,axiom,
    [--product(Y,X,V1),
     --product(Z,X,V2),
     --sum(Y,Z,V3),
     --product(V3,X,V4),
     ++sum(V1,V2,V4)]).

input_clause(distributivity4,axiom,
    [--product(Y,X,V1),
     --product(Z,X,V2),
     --sum(Y,Z,V3),
     --sum(V1,V2,V4),
     ++product(V3,X,V4)]).

%-----Equality axioms for operators 
input_clause(addition_is_well_defined,axiom,
    [--sum(X,Y,U),
     --sum(X,Y,V),
     ++equal(U,V)]).

input_clause(multiplication_is_well_defined,axiom,
    [--product(X,Y,U),
     --product(X,Y,V),
     ++equal(U,V)]).

%----Equality axioms for additive operator 
input_clause(additive_inverse_substitution,axiom,
    [--equal(X,Y),
     ++equal(additive_inverse(X),additive_inverse(Y))]).

input_clause(add_substitution1,axiom,
    [--equal(X,Y),
     ++equal(add(X,W),add(Y,W))]).

%----This axiom omited in this version 
%input_clause(add_substitution2,axiom,
%    [--equal(X,Y),
%     ++equal(add(W,X),add(W,Y))]).

input_clause(sum_substitution1,axiom,
    [--equal(X,Y),
     --sum(X,W,Z),
     ++sum(Y,W,Z)]).

input_clause(sum_substitution2,axiom,
    [--equal(X,Y),
     --sum(W,X,Z),
     ++sum(W,Y,Z)]).

input_clause(sum_substitution3,axiom,
    [--equal(X,Y),
     --sum(W,Z,X),
     ++sum(W,Z,Y)]).

%----Equality axioms for multiplicative operator 
input_clause(multiply_substitution1,axiom,
    [--equal(X,Y),
     ++equal(multiply(X,W),multiply(Y,W))]).

%----This axiom omited in this version 
%input_clause(multiply_substitution2,axiom,
%    [--equal(X,Y),
%     ++equal(multiply(W,X),multiply(W,Y))]).

input_clause(product_substitution1,axiom,
    [--equal(X,Y),
     --product(X,W,Z),
     ++product(Y,W,Z)]).

input_clause(product_substitution2,axiom,
    [--equal(X,Y),
     --product(W,X,Z),
     ++product(W,Y,Z)]).

input_clause(product_substitution3,axiom,
    [--equal(X,Y),
     --product(W,Z,X),
     ++product(W,Z,Y)]).

input_clause(multiplicative_identity1,axiom,
    [++product(additive_identity,X,additive_identity)]).

input_clause(multiplicative_identity2,axiom,
    [++product(X,additive_identity,additive_identity)]).

input_clause(some_property,hypothesis,
    [--equal(X,additive_identity),
     ++product(X,h(X,Y),Y)]).

input_clause(a_times_b,hypothesis,
    [++product(a,b,additive_identity)]).

input_clause(a_not_additive_identity,hypothesis,
    [--equal(a,additive_identity)]).

input_clause(prove_b_is_additive_identity,theorem,
    [--equal(b,additive_identity)]).
%--------------------------------------------------------------------------
