%--------------------------------------------------------------------------
% File     : RNG038=RngEqn1-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : Ring property 1
% Version  : [Wos, 1965] axioms.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [SPRFN]
% Names    : Problem 27 [Wos, 1965]

% Status   : 
% Syntax   : Number of clauses           :   37 (   0 non-Horn)(  10 unit)
%            Number of literals          :   93 (  31 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    7 (   3 constant)
%            Number of variables         :  123 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : These are the same axioms as in [McCharen, et al., 1976].
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include ring theory axioms 
include('Axioms/RNG001-0.ax').
%----Include substitution axioms 
include('Axioms/RNG001-0.eq').
%--------------------------------------------------------------------------
input_clause(some_property,hypothesis,
    [--equal(X,additive_identity),
     ++product(X,h(X,Y),Y)]).

input_clause(h_substitution1,axiom,
    [--equal(A,B),
     ++equal(h(A,C),h(B,C))]).

input_clause(h_substitution2,axiom,
    [--equal(D,E),
     ++equal(h(F,D),h(F,E))]).

input_clause(a_times_b,hypothesis,
    [++product(a,b,additive_identity)]).

input_clause(a_not_additive_identity,hypothesis,
    [--equal(a,additive_identity)]).

input_clause(prove_b_is_additive_identity,theorem,
    [--equal(b,additive_identity)]).
%--------------------------------------------------------------------------
