%--------------------------------------------------------------------------
% File     : RNG037=SumEqAId2-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : (X*Y^-1) + (X*Y) = additive_identity
% Version  : [Wos, 1965] axioms.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [SPRFN]
% Names    : Problem 24 [Wos, 1965]

% Status   : 
% Syntax   : Number of clauses           :   34 (   0 non-Horn)(  10 unit)
%            Number of literals          :   87 (  24 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    8 (   5 constant)
%            Number of variables         :  115 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : These are the same axioms as in [McCharen, et al., 1976].
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include ring theory axioms 
include('Axioms/RNG001-0.ax').
%----Include substitution axioms 
include('Axioms/RNG001-0.eq').
%--------------------------------------------------------------------------
input_clause(a_times_b,hypothesis,
    [++product(a,b,d)]).

input_clause(a_inverse_times_b,hypothesis,
    [++product(a,additive_inverse(b),c)]).

input_clause(prove_sum_is_additive_identity,theorem,
    [--sum(c,d,additive_identity)]).
%--------------------------------------------------------------------------
