%--------------------------------------------------------------------------
% File     : RNG034=AssrSkewSymm-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory (Alternative)
% Problem  : A skew symmetry relation of the associator
% Version  : [Anantharaman & Hsiang, 1990] (equality) axioms.
% English  : 

% Refs     : Anantharaman S., Hsiang J. (1990), Automated Proofs of the 
%            Moufang Identities in Alternative Rings, In Journal 
%            of Automated Reasoning 6(1), Kluwer Academic Publishers, 
%            Dordrecht, The Netherlands, 79-110.
% Source   : [Anantharaman & Hsiang, 1990]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   30 (   0 non-Horn)(  18 unit)
%            Number of literals          :   43 (  43 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    8 (   4 constant)
%            Number of variables         :   67 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Ring theory (equality) axioms 
include('Axioms/RNG004-0.ax').
%--------------------------------------------------------------------------
%----Associator 
input_clause(associator,axiom,
    [++equal(associator(X,Y,Z),add(multiply(multiply(X,Y),Z),
additive_inverse(multiply(X,multiply(Y,Z)))))]).

input_clause(associator_substitution1,axiom,
    [--equal(L,M),
     ++equal(associator(L,N,O),associator(M,N,O))]).

input_clause(associator_substitution2,axiom,
    [--equal(P,Q),
     ++equal(associator(R,P,S),associator(R,Q,S))]).

input_clause(associator_substitution3,axiom,
    [--equal(T,U),
     ++equal(associator(V,W,T),associator(V,W,U))]).

input_clause(prove_skew_symmetry,theorem,
    [--equal(associator(cy,cx,cz),additive_inverse(associator(cx,cy,cz)))]).
%--------------------------------------------------------------------------
