%--------------------------------------------------------------------------
% File     : RNG033=AssrEqn5-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory (Alternative)
% Problem  : A fairly complex equation with associators
% Version  : [Stevens, 1987] (equality) axioms : Augmented.
% English  : assr(X.Y,Z,W)+assr(X,Y,comm(Z,W)) =
%                X.assr(Y,Z,W)+assr(X,Z,W).Y

% Refs     : Stevens R.L. (1987), Some Experiments in Nonassociative Ring 
%            Theory with an Automated Theorem Prover, In Journal 
%            of Automated Reasoning 3(2), Kluwer Academic Publishers, 
%            Dordrecht, The Netherlands, 211-221.
% Source   : [Stevens, 1987]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   30 (   0 non-Horn)(  18 unit)
%            Number of literals          :   43 (  43 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :   10 (   5 constant)
%            Number of variables         :   68 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : This includes the right Moufang identity, which Stevens 
%            suggests in a useful lemma for this problem.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include nonassociative ring axioms 
include('Axioms/RNG003-0.ax').
%--------------------------------------------------------------------------
input_clause(right_moufang,axiom,
    [++equal(multiply(X,associator(Y,Z,Y)),multiply(commutator(
multiply(X,Y),Z),Y))]).

input_clause(prove_challenge,theorem,
    [--equal(add(associator(multiply(x,y),z,w),associator(x,y,
commutator(z,w))),add(multiply(x,associator(y,z,w)),multiply(
associator(x,z,w),y)))]).
%--------------------------------------------------------------------------
