%--------------------------------------------------------------------------
% File     : RNG028=LMoufang-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory (Alternative)
% Problem  : Left Moufang identity
% Version  : [Anantharaman & Hsiang, 1990] (equality) axioms.
% English  : 

% Refs     : Anantharaman S., Hsiang J. (1990), Automated Proofs of the 
%            Moufang Identities in Alternative Rings, In Journal 
%            of Automated Reasoning 6(1), Kluwer Academic Publishers, 
%            Dordrecht, The Netherlands, 79-110.
% Source   : [Anantharaman & Hsiang, 1990]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   26 (   0 non-Horn)(  17 unit)
%            Number of literals          :   36 (  36 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    7 (   4 constant)
%            Number of variables         :   52 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Ring theory (equality) axioms 
include('Axioms/RNG004-0.ax').
%--------------------------------------------------------------------------
input_clause(prove_left_moufang,theorem,
    [--equal(multiply(multiply(cx,multiply(cy,cx)),cz),
multiply(cx,multiply(cy,multiply(cx,cz))))]).
%--------------------------------------------------------------------------
