%--------------------------------------------------------------------------
% File     : RNG027=RMoufang-8 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory (Alternative)
% Problem  : Right Moufang identity
% Version  : [Stevens, 1987] (equality) axioms.
%            Theorem formulation : Associators.
% English  : 

% Refs     : Stevens R.L. (1987), Some Experiments in Nonassociative Ring 
%            Theory with an Automated Theorem Prover, In Journal 
%            of Automated Reasoning 3(2), Kluwer Academic Publishers, 
%            Dordrecht, The Netherlands, 211-221.
%          : Stevens R.L. (1988), Challenge Problems from Nonassociative 
%            Rings for Theorem Provers, In Proceedings of the 9th 
%            International Conference on Automated Deduction (Argonne, IL, 
%            1988), (Lecture Notes in Computer Science, 310), 730-734.
% Source   : [Stevens, 1987]
% Names    : m1' [Stevens, 1987]

% Status   : 
% Syntax   : Number of clauses           :   29 (   0 non-Horn)(  17 unit)
%            Number of literals          :   42 (  42 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    9 (   4 constant)
%            Number of variables         :   65 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : In [Stevens, 1988], Stevens presents a slightly different set 
%            of axioms for proving this theorem. The axioms are so similar 
%            to those in RNG004.ax that a separate problems has not been 
%            created.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include nonassociative ring axioms 
include('Axioms/RNG003-0.ax').
%--------------------------------------------------------------------------
input_clause(prove_right_moufang,theorem,
    [--equal(associator(x,multiply(x,y),z),multiply(associator(
x,y,z),x))]).
%--------------------------------------------------------------------------
