%--------------------------------------------------------------------------
% File     : RNG027=RMoufang-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory (Alternative)
% Problem  : Right Moufang identity
% Version  : [Anantharaman & Hsiang, 1990] (equality) axioms : Augmented.
% English  : 

% Refs     : Anantharaman S., Hsiang J. (1990), Automated Proofs of the 
%            Moufang Identities in Alternative Rings, In Journal 
%            of Automated Reasoning 6(1), Kluwer Academic Publishers, 
%            Dordrecht, The Netherlands, 79-110.
% Source   : [Anantharaman & Hsiang, 1990]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   33 (   0 non-Horn)(  21 unit)
%            Number of literals          :   46 (  46 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    8 (   4 constant)
%            Number of variables         :   75 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : This how the problem appears in [Anantharaman & Hsiang, 
%            1990].
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Ring theory (equality) axioms 
include('Axioms/RNG004-0.ax').
%--------------------------------------------------------------------------
%----Associator 
input_clause(associator,axiom,
    [++equal(associator(X,Y,Z),add(multiply(multiply(X,Y),Z),
additive_inverse(multiply(X,multiply(Y,Z)))))]).

input_clause(associator_substitution1,axiom,
    [--equal(L,M),
     ++equal(associator(L,N,O),associator(M,N,O))]).

input_clause(associator_substitution2,axiom,
    [--equal(P,Q),
     ++equal(associator(R,P,S),associator(R,Q,S))]).

input_clause(associator_substitution3,axiom,
    [--equal(T,U),
     ++equal(associator(V,W,T),associator(V,W,U))]).

%----The next three clauses are previously proved lemmas 
input_clause(middle_law,axiom,
    [--equal(multiply(multiply(Y,X),Y),multiply(Y,multiply(X,Y)))]).

input_clause(associator_skew_symmetry1,axiom,
    [--equal(associator(Y,X,Z),additive_inverse(associator(X,Y,Z)))]).

input_clause(associator_skew_symmetry2,axiom,
    [--equal(associator(Z,Y,X),additive_inverse(associator(X,Y,Z)))]).

input_clause(prove_right_moufang,theorem,
    [--equal(multiply(cz,multiply(cx,multiply(cy,cx))),
multiply(multiply(multiply(cz,cx),cy),cx))]).
%--------------------------------------------------------------------------
