%--------------------------------------------------------------------------
% File     : RNG026=TeichId-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory (Alternative)
% Problem  : Teichmuller Identity
% Version  : [Stevens, 1987] (equality) axioms.
% English  : 

% Refs     : Stevens R.L. (1987), Some Experiments in Nonassociative Ring 
%            Theory with an Automated Theorem Prover, In Journal 
%            of Automated Reasoning 3(2), Kluwer Academic Publishers, 
%            Dordrecht, The Netherlands, 211-221.
% Source   : [Stevens, 1987]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   29 (   0 non-Horn)(  17 unit)
%            Number of literals          :   42 (  42 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :   10 (   5 constant)
%            Number of variables         :   65 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    7

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include nonassociative ring axioms 
include('Axioms/RNG003-0.ax').
%--------------------------------------------------------------------------
input_clause(prove_teichmuller_identity,theorem,
    [--equal(add(add(associator(multiply(a,b),c,d),associator(a,b,
multiply(c,d))),additive_inverse(add(add(associator(a,
multiply(b,c),d),multiply(a,associator(b,c,d))),multiply(
associator(a,b,c),d)))),additive_identity)]).
%--------------------------------------------------------------------------
