%--------------------------------------------------------------------------
% File     : RNG025=FlexLaw-9 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory (Alternative)
% Problem  : Middle or Flexible Law
% Version  : [Stevens, 1987] (equality) axioms :
%            Reduced & Augmented > Complete.
%            Theorem formulation : Linearized.
% English  : 

% Refs     : Stevens R.L. (1987), Some Experiments in Nonassociative Ring 
%            Theory with an Automated Theorem Prover, In Journal 
%            of Automated Reasoning 3(2), Kluwer Academic Publishers, 
%            Dordrecht, The Netherlands, 211-221.
% Source   : [Stevens, 1987]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   38 (   0 non-Horn)(  26 unit)
%            Number of literals          :   51 (  51 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    9 (   4 constant)
%            Number of variables         :   92 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Don't Include nonassociative ring axioms.
%----The associator has to be replaced by its linearised form. 
% include('axioms/RNG003-0.ax').
%--------------------------------------------------------------------------
%----The next 7 clause are extra lemmas which Stevens found useful 
input_clause(product_of_inverses,axiom,
    [++equal(multiply(additive_inverse(X),additive_inverse(Y)),
multiply(X,Y))]).

input_clause(inverse_product1,axiom,
    [++equal(multiply(additive_inverse(X),Y),additive_inverse(
multiply(X,Y)))]).

input_clause(inverse_product2,axiom,
    [++equal(multiply(X,additive_inverse(Y)),additive_inverse(
multiply(X,Y)))]).

input_clause(distributivity_of_difference1,axiom,
    [++equal(multiply(X,add(Y,additive_inverse(Z))),add(multiply(X,Y),
additive_inverse(multiply(X,Z))))]).

input_clause(distributivity_of_difference2,axiom,
    [++equal(multiply(add(X,additive_inverse(Y)),Z),add(multiply(X,Z),
additive_inverse(multiply(Y,Z))))]).

input_clause(distributivity_of_difference3,axiom,
    [++equal(multiply(additive_inverse(X),add(Y,Z)),add(
additive_inverse(multiply(X,Y)),additive_inverse(multiply(X,Z))))]).

input_clause(distributivity_of_difference4,axiom,
    [++equal(multiply(add(X,Y),additive_inverse(Z)),add(
additive_inverse(multiply(X,Z)),additive_inverse(multiply(Y,Z))))]).

%----Commutativity for addition 
input_clause(commutativity_for_addition,axiom,
    [++equal(add(X,Y),add(Y,X))]).

%----Associativity for addition 
input_clause(associativity_for_addition,axiom,
    [++equal(add(X,add(Y,Z)),add(add(X,Y),Z))]).

%----There exists an additive identity element 
input_clause(left_additive_identity,axiom,
    [++equal(add(additive_identity,X),X)]).

input_clause(right_additive_identity,axiom,
    [++equal(add(X,additive_identity),X)]).

%----Multiplicative zero 
input_clause(left_multiplicative_zero,axiom,
    [++equal(multiply(additive_identity,X),additive_identity)]).

input_clause(right_multiplicative_zero,axiom,
    [++equal(multiply(X,additive_identity),additive_identity)]).

%----Existence of left additive additive_inverse 
input_clause(left_additive_inverse,axiom,
    [++equal(add(additive_inverse(X),X),additive_identity)]).

input_clause(right_additive_inverse,axiom,
    [++equal(add(X,additive_inverse(X)),additive_identity)]).

%----Distributive property of product over sum 
input_clause(distribute1,axiom,
    [++equal(multiply(X,add(Y,Z)),add(multiply(X,Y),multiply(X,Z)))]).

input_clause(distribute2,axiom,
    [++equal(multiply(add(X,Y),Z),add(multiply(X,Z),multiply(Y,Z)))]).

%----Inverse of additive_inverse of X is X 
input_clause(additive_inverse_additive_inverse,axiom,
    [++equal(additive_inverse(additive_inverse(X)),X)]).

%----Right alternative law 
input_clause(right_alternative,axiom,
    [++equal(multiply(multiply(X,Y),Y),multiply(X,multiply(Y,Y)))]).

%----Left alternative law 
input_clause(left_alternative,axiom,
    [++equal(multiply(multiply(X,X),Y),multiply(X,multiply(X,Y)))]).

%----Associator 
% input_clause(associator,axiom,
%     [++equal(associator(X,Y,Z),add(multiply(multiply(X,Y),Z),
% additive_inverse(multiply(X,multiply(Y,Z)))))]).

%----Linearised for of the associator 
input_clause(linearised_associator1,axiom,
    [++equal(associator(X,Y,add(U,V)),add(associator(X,Y,U),
associator(X,Y,V)))]).

input_clause(linearised_associator2,axiom,
    [++equal(associator(X,add(U,V),Y),add(associator(X,U,Y),
associator(X,V,Y)))]).

input_clause(linearised_associator3,axiom,
    [++equal(associator(add(U,V),X,Y),add(associator(U,X,Y),
associator(V,X,Y)))]).

%----Commutator 
input_clause(commutator,axiom,
    [++equal(commutator(X,Y),add(multiply(Y,X),additive_inverse(
multiply(X,Y))))]).

%----Substitution axioms 
input_clause(add_substitution1,axiom,
    [--equal(D,E),
     ++equal(add(D,F),add(E,F))]).

input_clause(add_substitution2,axiom,
    [--equal(G,H),
     ++equal(add(I,G),add(I,H))]).

input_clause(additive_inverse_substitution1,axiom,
    [--equal(J,K),
     ++equal(additive_inverse(J),additive_inverse(K))]).

input_clause(associator_substitution1,axiom,
    [--equal(L,M),
     ++equal(associator(L,N,O),associator(M,N,O))]).

input_clause(associator_substitution2,axiom,
    [--equal(P,Q),
     ++equal(associator(R,P,S),associator(R,Q,S))]).

input_clause(associator_substitution3,axiom,
    [--equal(T,U),
     ++equal(associator(V,W,T),associator(V,W,U))]).

input_clause(commutator_substitution1,axiom,
    [--equal(X,Y),
     ++equal(commutator(X,Z),commutator(Y,Z))]).

input_clause(commutator_substitution2,axiom,
    [--equal(A1,B1),
     ++equal(commutator(C1,A1),commutator(C1,B1))]).

input_clause(multiply_substitution1,axiom,
    [--equal(D1,E1),
     ++equal(multiply(D1,F1),multiply(E1,F1))]).

input_clause(multiply_substitution2,axiom,
    [--equal(G1,H1),
     ++equal(multiply(I1,G1),multiply(I1,H1))]).

input_clause(prove_flexible_law,theorem,
    [--equal(add(associator(a,b,c),associator(a,c,b)),
additive_identity)]).
%--------------------------------------------------------------------------
