%--------------------------------------------------------------------------
% File     : RNG021=LinAssr3-7 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory (Alternative)
% Problem  : Third part of the linearised form of the associator
% Version  : [Stevens, 1987] (equality) axioms : Augmented.
% English  : The associator can be expressed in another form called 
%            a linearised form. There are three clauses to be proved 
%            to establish the equivalence of the two forms.

% Refs     : Stevens R.L. (1987), Some Experiments in Nonassociative Ring 
%            Theory with an Automated Theorem Prover, In Journal 
%            of Automated Reasoning 3(2), Kluwer Academic Publishers, 
%            Dordrecht, The Netherlands, 211-221.
% Source   : [Stevens, 1987]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   36 (   0 non-Horn)(  24 unit)
%            Number of literals          :   49 (  49 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :   10 (   5 constant)
%            Number of variables         :   83 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include nonassociative ring axioms 
include('Axioms/RNG003-0.ax').
%--------------------------------------------------------------------------
%----The next 7 clause are extra lemmas which Stevens found useful 
input_clause(product_of_inverses,axiom,
    [++equal(multiply(additive_inverse(X),additive_inverse(Y)),
multiply(X,Y))]).

input_clause(inverse_product1,axiom,
    [++equal(multiply(additive_inverse(X),Y),additive_inverse(
multiply(X,Y)))]).

input_clause(inverse_product2,axiom,
    [++equal(multiply(X,additive_inverse(Y)),additive_inverse(
multiply(X,Y)))]).

input_clause(distributivity_of_difference1,axiom,
    [++equal(multiply(X,add(Y,additive_inverse(Z))),add(multiply(X,Y),
additive_inverse(multiply(X,Z))))]).

input_clause(distributivity_of_difference2,axiom,
    [++equal(multiply(add(X,additive_inverse(Y)),Z),add(multiply(X,Z),
additive_inverse(multiply(Y,Z))))]).

input_clause(distributivity_of_difference3,axiom,
    [++equal(multiply(additive_inverse(X),add(Y,Z)),add(
additive_inverse(multiply(X,Y)),additive_inverse(multiply(X,Z))))]).

input_clause(distributivity_of_difference4,axiom,
    [++equal(multiply(add(X,Y),additive_inverse(Z)),add(
additive_inverse(multiply(X,Z)),additive_inverse(multiply(Y,Z))))]).

input_clause(prove_linearised_form3,theorem,
    [--equal(associator(add(u,v),x,y),add(associator(u,x,y),
associator(v,x,y)))]).
%--------------------------------------------------------------------------
