%--------------------------------------------------------------------------
% File     : RNG019=LinAssr1-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory (Alternative)
% Problem  : First part of the linearised form of the associator
% Version  : [Stevens, 1987] (equality) axioms.
% English  : The associator can be expressed in another form called 
%            a linearised form. There are three clauses to be proved 
%            to establish the equivalence of the two forms.

% Refs     : Stevens R.L. (1987), Some Experiments in Nonassociative Ring 
%            Theory with an Automated Theorem Prover, In Journal 
%            of Automated Reasoning 3(2), Kluwer Academic Publishers, 
%            Dordrecht, The Netherlands, 211-221.
% Source   : [Stevens, 1987]
% Names    : c24 [Stevens, 1987]

% Status   : 
% Syntax   : Number of clauses           :   29 (   0 non-Horn)(  17 unit)
%            Number of literals          :   42 (  42 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :   10 (   5 constant)
%            Number of variables         :   65 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include nonassociative ring axioms 
include('Axioms/RNG003-0.ax').
%--------------------------------------------------------------------------
input_clause(prove_linearised_form1,theorem,
    [--equal(associator(x,y,add(u,v)),add(associator(x,y,u),
associator(x,y,v)))]).
%--------------------------------------------------------------------------
