%--------------------------------------------------------------------------
% File     : RNG011=RAltEqn-5 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : In a right alternative ring (((X,X,Y)*X)*(X,X,Y)) = Add Id
% Version  : [Overbeek, 1990] (equality) axioms :
%            Incomplete > Augmented > Incomplete.
% English  : 

% Refs     : Overbeek R. (1990), ATP competition announced at CADE-10.
%          : Overbeek R. (1993), The CADE-11 Competitions: A Personal 
%            View, Journal of Automated Reasoning 11(3), 315-316.
%          : Lusk E.L., McCune W.W. (1993), Uniform Strategies: The 
%            CADE-11 Theorem Proving Contest, Journal of Automated 
%            Reasoning 11(3), 317-331.
%          : Zhang H. (1993), Automated Proofs of Equality Problems 
%            in Overbeek's Competition, Journal of Automated Reasoning 
%            11(3), 333-351.
% Source   : [Overbeek, 1990]
% Names    : Overbeek Competition Eq-10 [Overbeek, 1990]

% Status   : 
% Syntax   : Number of clauses           :   35 (   0 non-Horn)(  23 unit)
%            Number of literals          :   48 (  48 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    8 (   3 constant)
%            Number of variables         :   75 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(add_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(add(A,C),add(B,C))]).

input_clause(add_substitutivity2,axiom,
    [--equal(D,E),
     ++equal(add(F,D),add(F,E))]).

input_clause(additive_inverse_substitutivity1,axiom,
    [--equal(G,H),
     ++equal(additive_inverse(G),additive_inverse(H))]).

input_clause(multiply_substitutivity1,axiom,
    [--equal(I,J),
     ++equal(multiply(I,K),multiply(J,K))]).

input_clause(multiply_substitutivity2,axiom,
    [--equal(L,M),
     ++equal(multiply(N,L),multiply(N,M))]).

input_clause(associator_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(associator(A,C,D),associator(B,C,D))]).

input_clause(associator_substitutivity2,axiom,
    [--equal(E,F),
     ++equal(associator(G,E,H),associator(G,F,H))]).

input_clause(associator_substitutivity3,axiom,
    [--equal(I,J),
     ++equal(associator(K,L,I),associator(K,L,J))]).

input_clause(commutator_substitutivity1,axiom,
    [--equal(M,N),
     ++equal(commutator(M,O),commutator(N,O))]).

input_clause(commutator_substitutivity2,axiom,
    [--equal(P,Q),
     ++equal(commutator(R,P),commutator(R,Q))]).

%----Commutativity of addition 
input_clause(commutative_addition,axiom,
    [++equal(add(X,Y),add(Y,X))]).

%----Associativity of addition 
input_clause(associative_addition,axiom,
    [++equal(add(add(X,Y),Z),add(X,add(Y,Z)))]).

%----Additive identity 
input_clause(right_identity,axiom,
    [++equal(add(X,additive_identity),X)]).

input_clause(left_identity,axiom,
    [++equal(add(additive_identity,X),X)]).

%----Additive inverse 
input_clause(right_additive_inverse,axiom,
    [++equal(add(X,additive_inverse(X)),additive_identity)]).

input_clause(left_additive_inverse,axiom,
    [++equal(add(additive_inverse(X),X),additive_identity)]).

%----Inverse of identity is identity, stupid 
input_clause(additive_inverse_identity,axiom,
    [++equal(additive_inverse(additive_identity),additive_identity)]).

%----Axiom of Overbeek 
input_clause(property_of_inverse_and_add,axiom,
    [++equal(add(X,add(additive_inverse(X),Y)),Y)]).

%----Inverse of (x + y) is additive_inverse(x) + additive_inverse(y), 
input_clause(distribute_additive_inverse,axiom,
    [++equal(additive_inverse(add(X,Y)),add(additive_inverse(X),
additive_inverse(Y)))]).

%----Inverse of additive_inverse of X is X 
input_clause(additive_inverse_additive_inverse,axiom,
    [++equal(additive_inverse(additive_inverse(X)),X)]).

%----Behavior of 0 and the multiplication operation 
input_clause(multiply_additive_id1,axiom,
    [++equal(multiply(X,additive_identity),additive_identity)]).

input_clause(multiply_additive_id2,axiom,
    [++equal(multiply(additive_identity,X),additive_identity)]).

%----Axiom of Overbeek 
input_clause(product_of_inverse,axiom,
    [++equal(multiply(additive_inverse(X),additive_inverse(Y)),
multiply(X,Y))]).

%----x * additive_inverse(y) = additive_inverse (x * y), 
input_clause(multiply_additive_inverse1,axiom,
    [++equal(multiply(X,additive_inverse(Y)),
additive_inverse(multiply(X,Y)))]).

input_clause(multiply_additive_inverse2,axiom,
    [++equal(multiply(additive_inverse(X),Y),
additive_inverse(multiply(X,Y)))]).

%----Distributive property of product over sum 
input_clause(distribute1,axiom,
    [++equal(multiply(X,add(Y,Z)),add(multiply(X,Y),multiply(X,Z)))]).

input_clause(distribute2,axiom,
    [++equal(multiply(add(X,Y),Z),add(multiply(X,Z),multiply(Y,Z)))]).

%----Right alternative law 
input_clause(right_alternative,axiom,
    [++equal(multiply(multiply(X,Y),Y),multiply(X,multiply(Y,Y)))]).

%----Associator 
input_clause(associator,axiom,
    [++equal(associator(X,Y,Z),add(multiply(multiply(X,Y),Z),
additive_inverse(multiply(X,multiply(Y,Z)))))]).

%----Commutator 
input_clause(commutator,axiom,
    [++equal(commutator(X,Y),add(multiply(Y,X),additive_inverse(
multiply(X,Y))))]).

%----Middle associator identity 
input_clause(middle_associator,axiom,
    [++equal(multiply(multiply(associator(X,X,Y),X),associator(X,X,Y)),
additive_identity)]).

input_clause(prove_equality,theorem,
    [--equal(multiply(multiply(associator(a,a,b),a),associator(a,a,b)),
additive_identity)]).
%--------------------------------------------------------------------------
