%--------------------------------------------------------------------------
% File     : RNG010=AuxSkewSymm-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory (Right alternative)
% Problem  : Skew symmetry of the auxilliary function
% Version  : [Stevens, 1987] (equality) axioms : Reduced > Complete.
% English  : The three Moufang identities imply the skew symmetry 
%            of s(W,X,Y,Z) = (W*X,Y,Z) - X*(W,Y,Z) - (X,Y,Z)*W.
%            Recall that skew symmetry means that the function sign 
%            changes when any two arguments are swapped. This problem 
%            proves the case for swapping the first two arguments.

% Refs     : Stevens R.L. (1987), Some Experiments in Nonassociative Ring 
%            Theory with an Automated Theorem Prover, In Journal 
%            of Automated Reasoning 3(2), Kluwer Academic Publishers, 
%            Dordrecht, The Netherlands, 211-221.
% Source   : [Stevens, 1987]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   36 (   0 non-Horn)(  20 unit)
%            Number of literals          :   53 (  53 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :   11 (   5 constant)
%            Number of variables         :   96 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Don't Include nonassociative ring axioms.
%----The left alternative law has to be omitted.
% include('axioms/RNG003-0.ax').
%--------------------------------------------------------------------------
%----Commutativity for addition 
input_clause(commutativity_for_addition,axiom,
    [++equal(add(X,Y),add(Y,X))]).

%----Associativity for addition 
input_clause(associativity_for_addition,axiom,
    [++equal(add(X,add(Y,Z)),add(add(X,Y),Z))]).

%----There exists an additive identity element 
input_clause(left_additive_identity,axiom,
    [++equal(add(additive_identity,X),X)]).

input_clause(right_additive_identity,axiom,
    [++equal(add(X,additive_identity),X)]).

%----Multiplicative zero 
input_clause(left_multiplicative_zero,axiom,
    [++equal(multiply(additive_identity,X),additive_identity)]).

input_clause(right_multiplicative_zero,axiom,
    [++equal(multiply(X,additive_identity),additive_identity)]).

%----Existence of left additive additive_inverse 
input_clause(left_additive_inverse,axiom,
    [++equal(add(additive_inverse(X),X),additive_identity)]).

input_clause(right_additive_inverse,axiom,
    [++equal(add(X,additive_inverse(X)),additive_identity)]).

%----Distributive property of product over sum 
input_clause(distribute1,axiom,
    [++equal(multiply(X,add(Y,Z)),add(multiply(X,Y),multiply(X,Z)))]).

input_clause(distribute2,axiom,
    [++equal(multiply(add(X,Y),Z),add(multiply(X,Z),multiply(Y,Z)))]).

%----Inverse of additive_inverse of X is X 
input_clause(additive_inverse_additive_inverse,axiom,
    [++equal(additive_inverse(additive_inverse(X)),X)]).

%----Right alternative law 
input_clause(right_alternative,axiom,
    [++equal(multiply(multiply(X,Y),Y),multiply(X,multiply(Y,Y)))]).

%----Left alternative law 
% input_clause(left_alternative,axiom,
%     [++equal(multiply(multiply(X,X),Y),multiply(X,multiply(X,Y)))]).

%----Associator 
input_clause(associator,axiom,
    [++equal(associator(X,Y,Z),add(multiply(multiply(X,Y),Z),
additive_inverse(multiply(X,multiply(Y,Z)))))]).

%----Commutator 
input_clause(commutator,axiom,
    [++equal(commutator(X,Y),add(multiply(Y,X),additive_inverse(
multiply(X,Y))))]).

%----Substitution axioms 
input_clause(add_substitution1,axiom,
    [--equal(D,E),
     ++equal(add(D,F),add(E,F))]).

input_clause(add_substitution2,axiom,
    [--equal(G,H),
     ++equal(add(I,G),add(I,H))]).

input_clause(additive_inverse_substitution1,axiom,
    [--equal(J,K),
     ++equal(additive_inverse(J),additive_inverse(K))]).

input_clause(associator_substitution1,axiom,
    [--equal(L,M),
     ++equal(associator(L,N,O),associator(M,N,O))]).

input_clause(associator_substitution2,axiom,
    [--equal(P,Q),
     ++equal(associator(R,P,S),associator(R,Q,S))]).

input_clause(associator_substitution3,axiom,
    [--equal(T,U),
     ++equal(associator(V,W,T),associator(V,W,U))]).

input_clause(commutator_substitution1,axiom,
    [--equal(X,Y),
     ++equal(commutator(X,Z),commutator(Y,Z))]).

input_clause(commutator_substitution2,axiom,
    [--equal(A1,B1),
     ++equal(commutator(C1,A1),commutator(C1,B1))]).

input_clause(multiply_substitution1,axiom,
    [--equal(D1,E1),
     ++equal(multiply(D1,F1),multiply(E1,F1))]).

input_clause(multiply_substitution2,axiom,
    [--equal(G1,H1),
     ++equal(multiply(I1,G1),multiply(I1,H1))]).

%----Definition of s 
input_clause(defines_s,axiom,
    [++equal(s(W,X,Y,Z),add(add(associator(multiply(W,X),Y,Z),
additive_inverse(multiply(X,associator(W,Y,Z)))),additive_inverse(
multiply(associator(X,Y,Z),W))))]).

input_clause(s_substitutivity1,axiom,
    [--equal(S,T),
     ++equal(s(S,U,V,W),s(T,U,V,W))]).

input_clause(s_substitutivity2,axiom,
    [--equal(X,Y),
     ++equal(s(Z,X,A1,B1),s(Z,Y,A1,B1))]).

input_clause(s_substitutivity3,axiom,
    [--equal(C1,D1),
     ++equal(s(E1,F1,C1,G1),s(E1,F1,D1,G1))]).

input_clause(s_substitutivity4,axiom,
    [--equal(H1,I1),
     ++equal(s(J1,K1,L1,H1),s(J1,K1,L1,I1))]).

input_clause(right_moufang,hypothesis,
    [++equal(multiply(X,associator(Y,Z,Y)),multiply(commutator(
multiply(X,Y),Z),Y))]).

input_clause(left_moufang,hypothesis,
    [++equal(multiply(associator(Y,Z,Y),X),multiply(Y,commutator(
Z,multiply(Y,X))))]).

input_clause(middle_moufang,hypothesis,
    [++equal(multiply(multiply(X,Y),multiply(Z,X)),multiply(multiply(
X,multiply(Y,Z)),X))]).

input_clause(prove_skew_symmetry,theorem,
    [--equal(s(a,b,c,d),s(b,a,c,d))]).
%--------------------------------------------------------------------------
