%--------------------------------------------------------------------------
% File     : RNG010=AuxSkewSymm-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory (Alternative)
% Problem  : Skew symmetry of the auxilliary function
% Version  : [Anantharaman & Hsiang, 1990] (equality) axioms : Augmented.
%            Theorem formulation : In terms of the associator
% English  : The left and right Moufang identities imply the skew symmetry 
%            of s(W,X,Y,Z) = (W*X,Y,Z) - X*(W,Y,Z) - (X,Y,Z)*W.
%            Recall that skew symmetry means that the function sign 
%            changes when any two arguments are swapped. This problem 
%            proves the case for swapping the first two arguments.

% Refs     : Anantharaman S., Hsiang J. (1990), Automated Proofs of the 
%            Moufang Identities in Alternative Rings, In Journal 
%            of Automated Reasoning 6(1), Kluwer Academic Publishers, 
%            Dordrecht, The Netherlands, 79-110.
% Source   : [Anantharaman & Hsiang, 1990]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   35 (   0 non-Horn)(  23 unit)
%            Number of literals          :   48 (  48 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    8 (   4 constant)
%            Number of variables         :   81 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : This how the problem appears in [Anantharaman & Hsiang, 
%            1990].
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include Ring theory (equality) axioms 
include('Axioms/RNG004-0.ax').
%--------------------------------------------------------------------------
%----Associator 
input_clause(associator,axiom,
    [++equal(associator(X,Y,Z),add(multiply(multiply(X,Y),Z),
additive_inverse(multiply(X,multiply(Y,Z)))))]).

input_clause(associator_substitution1,axiom,
    [--equal(L,M),
     ++equal(associator(L,N,O),associator(M,N,O))]).

input_clause(associator_substitution2,axiom,
    [--equal(P,Q),
     ++equal(associator(R,P,S),associator(R,Q,S))]).

input_clause(associator_substitution3,axiom,
    [--equal(T,U),
     ++equal(associator(V,W,T),associator(V,W,U))]).

%----The next three clauses are previously proved lemmas 
input_clause(middle_law,axiom,
    [--equal(multiply(multiply(Y,X),Y),multiply(Y,multiply(X,Y)))]).

input_clause(associator_skew_symmetry1,axiom,
    [--equal(associator(Y,X,Z),additive_inverse(associator(X,Y,Z)))]).

input_clause(associator_skew_symmetry2,axiom,
    [--equal(associator(Z,Y,X),additive_inverse(associator(X,Y,Z)))]).

input_clause(right_moufang,hypothesis,
    [++equal(multiply(Z,multiply(X,multiply(Y,X))),
multiply(multiply(multiply(Z,X),Y),X))]).

input_clause(left_moufang,hypothesis,
    [--equal(multiply(multiply(X,multiply(Y,X)),Z),
multiply(X,multiply(Y,multiply(X,Z))))]).

input_clause(prove_skew_symmetry,theorem,
    [--equal(associator(multiply(cx,cx),cy,cz),
add(multiply(associator(cx,cy,cz),cx),multiply(cx,associator(cx,cy,cz))))]).
%--------------------------------------------------------------------------
