%--------------------------------------------------------------------------
% File     : RNG009=CubeComm-7 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : If X*X*X = X then the ring is commutative
% Version  : [Lusk & Wos, 1991] (equality) axioms.
% English  : Given a ring in which for all x, x * x * x = x, prove that 
%            for all x and y, x * y = y * x.

% Refs     : Lusk E., and Overbeek R. (1985), Reasoning about Equality, 
%            Journal of Automated Reasoning 1(2), 209-228.
%          : Lusk E., and Wos L. (1991), Benchmark Problems in Which 
%            Equality Plays the Major Role, MCS-P275-1191, Mathematics and 
%            Computer Science Division, Argonne National Laboratory, 
%            Argonne, IL.
% Source   : [Lusk & Wos, 1991]
% Names    : Problem 6 [Lusk & Overbeek, 1985]
%          : RT2 [Lusk & Wos, 1991]

% Status   : 
% Syntax   : Number of clauses           :   20 (   0 non-Horn)(  13 unit)
%            Number of literals          :   28 (  28 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    7 (   4 constant)
%            Number of variables         :   39 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include ring theory axioms 
include('Axioms/RNG005-0.ax').
%--------------------------------------------------------------------------
input_clause(x_cubed_is_x,hypothesis,
    [++equal(multiply(X,multiply(X,X)),X)]).

input_clause(a_times_b_is_c,theorem,
    [++equal(multiply(a,b),c)]).

input_clause(prove_commutativity,theorem,
    [--equal(multiply(b,a),c)]).
%--------------------------------------------------------------------------
