%--------------------------------------------------------------------------
% File     : RNG009=CubeComm-5 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : If X*X*X = X then the ring is commutative
% Version  : Stickel's (equality) axioms : Reduced > Incomplete.
% English  : Given a ring in which for all x, x * x * x = x, prove that 
%            for all x and y, x * y = y * x.

% Refs     : Overbeek R. (1990), ATP competition announced at CADE-10.
%          : Overbeek R. (1993), The CADE-11 Competitions: A Personal View,
%            Journal of Automated Reasoning 11(3), 315-316.
%          : Lusk E.L., McCune W.W. (1993), Uniform Strategies: The CADE-11
%            Theorem Proving Contest, Journal of Automated Reasoning 11(3),
%            317-331.
%          : Zhang H. (1993), Automated Proofs of Equality Problems in
%            Overbeek's Competition, Journal of Automated Reasoning 11(3),
%            333-351.
% Source   : [Overbeek, 1990]
% Names    : Overbeek Competition Eq-7 [Overbeek, 1990]

% Status   : 
% Syntax   : Number of clauses           :   17 (   0 non-Horn)(  10 unit)
%            Number of literals          :   25 (  25 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    6 (   3 constant)
%            Number of variables         :   37 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(add_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(add(A,C),add(B,C))]).

input_clause(add_substitutivity2,axiom,
    [--equal(D,E),
     ++equal(add(F,D),add(F,E))]).

input_clause(additive_inverse_substitutivity1,axiom,
    [--equal(G,H),
     ++equal(additive_inverse(G),additive_inverse(H))]).

input_clause(multiply_substitutivity1,axiom,
    [--equal(I,J),
     ++equal(multiply(I,K),multiply(J,K))]).

input_clause(multiply_substitutivity2,axiom,
    [--equal(L,M),
     ++equal(multiply(N,L),multiply(N,M))]).

%----Right identity and inverse 
input_clause(right_identity,axiom,
    [++equal(add(X,additive_identity),X)]).

input_clause(right_additive_inverse,axiom,
    [++equal(add(X,additive_inverse(X)),additive_identity)]).

%----Distributive property of product over sum 
input_clause(distribute1,axiom,
    [++equal(multiply(X,add(Y,Z)),add(multiply(X,Y),multiply(X,Z)))]).

input_clause(distribute2,axiom,
    [++equal(multiply(add(X,Y),Z),add(multiply(X,Z),multiply(Y,Z)))]).

%----Associativity of addition 
input_clause(associative_addition,axiom,
    [++equal(add(add(X,Y),Z),add(X,add(Y,Z)))]).

%----Commutativity of addition 
input_clause(commutative_addition,axiom,
    [++equal(add(X,Y),add(Y,X))]).

%----Associativity of product 
input_clause(associative_multiplication,axiom,
    [++equal(multiply(multiply(X,Y),Z),multiply(X,multiply(Y,Z)))]).

input_clause(x_cubed_is_x,hypothesis,
    [++equal(multiply(X,multiply(X,X)),X)]).

input_clause(prove_commutativity,theorem,
    [--equal(multiply(a,b),multiply(b,a))]).
%--------------------------------------------------------------------------
