%--------------------------------------------------------------------------
% File     : RNG008=BoolComm-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : Boolean rings are commutative
% Version  : [McCharen, et al., 1976] axioms : Augmented.
% English  : Given a ring in which for all x, x * x = x, prove that for 
%            all x and y, x * y = y * x.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Overbeek R. (1990), ATP competition announced at CADE-10.
%          : Overbeek R. (1993), The CADE-11 Competitions: A Personal 
%            View, Journal of Automated Reasoning 11(3), 315-316.
%          : Lusk E.L., McCune W.W. (1993), Uniform Strategies: The 
%            CADE-11 Theorem Proving Contest, Journal of Automated 
%            Reasoning 11(3), 317-331.
%          : Zhang H. (1993), Automated Proofs of Equality Problems 
%            in Overbeek's Competition, Journal of Automated Reasoning 
%            11(3), 333-351.
% Source   : [Overbeek, 1990]
% Names    : Overbeek Competition 3 [Overbeek, 1990]

% Status   : 
% Syntax   : Number of clauses           :   36 (   0 non-Horn)(  12 unit)
%            Number of literals          :   89 (  24 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    7 (   4 constant)
%            Number of variables         :  118 (   2 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : Supplies multiplication to identity as lemmas
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include ring theory axioms 
include('Axioms/RNG001-0.ax').
%----Include ring theory equality axioms 
include('Axioms/RNG001-0.eq').
%--------------------------------------------------------------------------
input_clause(x_times_identity_x_is_identity,axiom,
    [++product(X,additive_identity,additive_identity)]).

input_clause(identity_times_x_is_identity,axiom,
    [++product(additive_identity,X,additive_identity)]).

input_clause(x_squared_is_x,hypothesis,
    [++product(X,X,X)]).

input_clause(a_times_b_is_c,hypothesis,
    [++product(a,b,c)]).

input_clause(prove_b_times_a_is_c,theorem,
    [--product(b,a,c)]).
%--------------------------------------------------------------------------
