%--------------------------------------------------------------------------
% File     : RNG008=BoolComm-5 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : Boolean rings are commutative
% Version  : [McCharen, et al., 1976] axioms : Augmented.
%            Theorem formulation : Equality.
% English  : Given a ring in which for all x, x * x = x, prove that for 
%            all x and y, x * y = y * x.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Overbeek R. (1990), ATP competition announced at CADE-10.
% Source   : [ANL]
% Names    : commute.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   40 (   0 non-Horn)(  16 unit)
%            Number of literals          :   93 (  24 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    7 (   4 constant)
%            Number of variables         :  123 (   2 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    3

% Comments : Extra lemmas based on Stickel's equality axioms.
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include ring theory axioms 
include('Axioms/RNG001-0.ax').
%----Include ring theory equality axioms 
include('Axioms/RNG001-0.eq').
%--------------------------------------------------------------------------
%----The next six clauses are the extra lemmas.
%----Inverse of identity is identity 
input_clause(additive_inverse_identity,axiom,
    [++sum(additive_inverse(additive_identity),additive_identity,
additive_identity)]).

%----Inverse of inverse of X is X 
input_clause(additive_inverse_additive_inverse,axiom,
    [++sum(additive_inverse(additive_inverse(X)),additive_identity,X)]).

%----Behavior of additive_identity and the multiplication operation 
input_clause(multiply_additive_id1,axiom,
    [++product(X,additive_identity,additive_identity)]).

input_clause(multiply_additive_id2,axiom,
    [++product(additive_identity,X,additive_identity)]).

%----Inverse of (x + y) is additive_inverse(x) + additive_inverse(y), 
input_clause(distribute_additive_inverse,axiom,
    [++sum(additive_inverse(X),additive_inverse(Y),
additive_inverse(add(X,Y)))]).

%----x * additive_inverse(y) = additive_inverse (x * y), 
input_clause(multiply_additive_inverse,axiom,
    [++product(X,additive_inverse(Y),additive_inverse(multiply(X,Y)))]).

%----Clauses for the theorem 
input_clause(x_squared_is_x,hypothesis,
    [++product(X,X,X)]).

input_clause(a_times_b_is_c,hypothesis,
    [++product(a,b,c)]).

input_clause(prove_b_times_a_is_c,theorem,
    [--product(b,a,c)]).
%--------------------------------------------------------------------------
