%--------------------------------------------------------------------------
% File     : RNG008=BoolComm-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : Boolean rings are commutative
% Version  : Stickel's (equality) axioms.
%            Theorem formulation : Equality.
% English  : Given a ring in which for all x, x * x = x, prove that for 
%            all x and y, x * y = y * x.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [TPTP]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   25 (   0 non-Horn)(  18 unit)
%            Number of literals          :   33 (  33 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    7 (   4 constant)
%            Number of variables         :   46 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include ring theory axioms 
include('Axioms/RNG002-0.ax').
%--------------------------------------------------------------------------
input_clause(boolean_ring,hypothesis,
    [++equal(multiply(X,X),X)]).

input_clause(a_times_b_is_c,theorem,
    [++equal(multiply(a,b),c)]).

input_clause(prove_commutativity,theorem,
    [--equal(multiply(b,a),c)]).
%--------------------------------------------------------------------------
