%--------------------------------------------------------------------------
% File     : RNG008=BoolComm-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : Boolean rings are commutative
% Version  : Stickel's (equality) axioms : Augmented.
%            Theorem formulation : Equality.
% English  : Given a ring in which for all x, x * x = x, prove that for 
%            all x and y, x * y = y * x.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : commute.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   27 (   0 non-Horn)(  20 unit)
%            Number of literals          :   35 (  35 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    7 (   4 constant)
%            Number of variables         :   48 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include ring theory axioms 
include('Axioms/RNG002-0.ax').
%--------------------------------------------------------------------------
%----Right identity and inverse are dependent lemmas 
input_clause(right_identity,axiom,
    [++equal(add(X,additive_identity),X)]).

input_clause(right_inverse,axiom,
    [++equal(add(X,additive_inverse(X)),additive_identity)]).

input_clause(boolean_ring,hypothesis,
    [++equal(multiply(X,X),X)]).

input_clause(a_times_b_is_c,theorem,
    [++equal(multiply(a,b),c)]).

input_clause(prove_commutativity,theorem,
    [--equal(multiply(b,a),c)]).
%--------------------------------------------------------------------------
