%--------------------------------------------------------------------------
% File     : RNG008=BoolComm-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : Boolean rings are commutative
% Version  : [McCharen, et al., 1976] axioms : Augmented.
% English  : Given a ring in which for all x, x * x = x, prove that for 
%            all x and y, x * y = y * x.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Overbeek R., McCharen J., and Wos L. (1976), Complexity and 
%            Related Enhancements for Automated Theorem-Proving Programs, 
%            Computer and Mathematics with Applications 2,1-16.
% Source   : [McCharen, et al., 1976]
% Names    : R3 [McCharen, et al., 1976]
%          : Theorem 2 [Overbeek, et al., 1976]

% Status   : 
% Syntax   : Number of clauses           :   36 (   0 non-Horn)(  10 unit)
%            Number of literals          :   93 (  26 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    7 (   4 constant)
%            Number of variables         :  124 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include ring theory axioms 
include('Axioms/RNG001-0.ax').
%----Include ring theory equality axioms 
include('Axioms/RNG001-0.eq').
%--------------------------------------------------------------------------
input_clause(cancellation1,axiom,
    [--sum(X,Y,Z),
     --sum(X,W,Z),
     ++equal(Y,W)]).

input_clause(cancellation2,axiom,
    [--sum(X,Y,Z),
     --sum(W,Y,Z),
     ++equal(X,W)]).

input_clause(x_squared_is_x,hypothesis,
    [++product(X,X,X)]).

input_clause(a_times_b_is_c,hypothesis,
    [++product(a,b,c)]).

input_clause(prove_b_times_a_is_c,theorem,
    [--product(b,a,c)]).
%--------------------------------------------------------------------------
