%--------------------------------------------------------------------------
% File     : RNG008=BoolComm-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : Boolean rings are commutative
% Version  : [McCharen, et al., 1976] axioms.
% English  : Given a ring in which for all x, x * x = x, prove that for 
%            all x and y, x * y = y * x.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Wos L. (1988), Automated Reasoning: 33 Basic Research 
%            Problems, Prentice-Hall.
% Source   : [McCharen, et al., 1976]
% Names    : Test Problem 8 [Wos, 1988]
%          : Boolean Rings [Wos, 1988]
%          : commute.ver3.in [ANL]
%          : commute.ver4.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   34 (   0 non-Horn)(  10 unit)
%            Number of literals          :   87 (  24 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    7 (   4 constant)
%            Number of variables         :  116 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include ring theory axioms 
include('Axioms/RNG001-0.ax').
%----Include ring theory equality axioms 
include('Axioms/RNG001-0.eq').
%--------------------------------------------------------------------------
input_clause(x_squared_is_x,hypothesis,
    [++product(X,X,X)]).

input_clause(a_times_b_is_c,hypothesis,
    [++product(a,b,c)]).

input_clause(prove_b_times_a_is_c,theorem,
    [--product(b,a,c)]).
%--------------------------------------------------------------------------
