%--------------------------------------------------------------------------
% File     : RNG007=BoolInv-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : In Boolean rings, X is its own inverse
% Version  : Stickel's (equality) axioms.
%            Theorem formulation : Equality.
% English  : Given a ring in which for all x, x * x = x, prove that for 
%            all x, x + x = additive_identity

% Refs     : 
% Source   : [ANL]
% Names    : lemma.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   24 (   0 non-Horn)(  17 unit)
%            Number of literals          :   32 (  32 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   2 constant)
%            Number of variables         :   46 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include ring theory axioms 
include('Axioms/RNG002-0.ax').
%--------------------------------------------------------------------------
input_clause(boolean_ring,hypothesis,
    [++equal(multiply(X,X),X)]).

input_clause(prove_inverse,theorem,
    [--equal(add(a,a),additive_identity)]).
%--------------------------------------------------------------------------
