%--------------------------------------------------------------------------
% File     : RNG007=BoolInv-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : In Boolean rings, X is its own inverse
% Version  : [McCharen, et al., 1976] axioms.
% English  : Given a ring in which for all x, x * x = x, prove that for 
%            all x, x + x = additive_identity

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : lemma.ver3.in [ANL]
%          : lemma.ver4.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   33 (   0 non-Horn)(   9 unit)
%            Number of literals          :   86 (  24 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    5 (   2 constant)
%            Number of variables         :  116 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include ring theory axioms 
include('Axioms/RNG001-0.ax').
%----Include ring theory equality axioms 
include('Axioms/RNG001-0.eq').
%--------------------------------------------------------------------------
input_clause(x_squared_is_x,hypothesis,
    [++product(X,X,X)]).

input_clause(prove_a_plus_a_is_id,theorem,
    [--sum(a,a,additive_identity)]).
%--------------------------------------------------------------------------
