%--------------------------------------------------------------------------
% File     : RNG006=Eqn1-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : X*(Y+Z^-1) = (X*Y)+(X*Z)^-1
% Version  : [Wos, 1965] axioms.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
% Source   : [SPRFN]
% Names    : Problem 25 [Wos, 1965]

% Status   : 
% Syntax   : Number of clauses           :   36 (   0 non-Horn)(  12 unit)
%            Number of literals          :   89 (  24 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   11 (   8 constant)
%            Number of variables         :  115 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : These are the same axioms as in [McCharen, et al., 1976].
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include ring theory axioms 
include('Axioms/RNG001-0.ax').
%----Include ring theory equality axioms 
include('Axioms/RNG001-0.eq').
%--------------------------------------------------------------------------
input_clause(b_plus_inverse_c,hypothesis,
    [++sum(b,additive_inverse(c),bS_Ic)]).

input_clause(a_times_b,hypothesis,
    [++product(a,b,aPb)]).

input_clause(a_times_c,hypothesis,
    [++product(a,c,aPc)]).

input_clause(aPb_plus_IaPc,hypothesis,
    [++sum(aPb,additive_inverse(aPc),aPb_S_IaPc)]).

input_clause(prove_a_times_bS_Ic_is_aPb_S__IaPc,theorem,
    [--product(a,bS_Ic,aPb_S_IaPc)]).
%--------------------------------------------------------------------------
