%--------------------------------------------------------------------------
% File     : RNG006=Eqn1-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : X*(Y+Z^-1) = (X*Y)+(X*Z)^-1
% Version  : [Wos, 1965] axioms : Reduced & Augmented > Incomplete.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Problem 25 [Wos, 1965]
%          : wos25 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   36 (   0 non-Horn)(  13 unit)
%            Number of literals          :   87 (  14 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   11 (   8 constant)
%            Number of variables         :  114 (   2 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : These are the same axioms as in [McCharen, et al., 1976].
%--------------------------------------------------------------------------
%----Include ring theory axioms 
include('Axioms/RNG001-0.ax').
%--------------------------------------------------------------------------
%----Equality axioms for additive operator 
input_clause(additive_inverse_substitution,axiom,
    [--equal(X,Y),
     ++equal(additive_inverse(X),additive_inverse(Y))]).

input_clause(add_substitution1,axiom,
    [--equal(X,Y),
     ++equal(add(X,W),add(Y,W))]).

%----This axiom omited in this version 
%input_clause(add_substitution2,axiom,
%    [--equal(X,Y),
%     ++equal(add(W,X),add(W,Y))]).

input_clause(sum_substitution1,axiom,
    [--equal(X,Y),
     --sum(X,W,Z),
     ++sum(Y,W,Z)]).

input_clause(sum_substitution2,axiom,
    [--equal(X,Y),
     --sum(W,X,Z),
     ++sum(W,Y,Z)]).

input_clause(sum_substitution3,axiom,
    [--equal(X,Y),
     --sum(W,Z,X),
     ++sum(W,Z,Y)]).

%----Equality axioms for multiplicative operator 
input_clause(multiply_substitution1,axiom,
    [--equal(X,Y),
     ++equal(multiply(X,W),multiply(Y,W))]).

%----This axiom omited in this version 
%input_clause(multiply_substitution2,axiom,
%    [--equal(X,Y),
%     ++equal(multiply(W,X),multiply(W,Y))]).

input_clause(product_substitution1,axiom,
    [--equal(X,Y),
     --product(X,W,Z),
     ++product(Y,W,Z)]).

input_clause(product_substitution2,axiom,
    [--equal(X,Y),
     --product(W,X,Z),
     ++product(W,Y,Z)]).

input_clause(product_substitution3,axiom,
    [--equal(X,Y),
     --product(W,Z,X),
     ++product(W,Z,Y)]).

input_clause(multiplicative_identity1,axiom,
    [++product(additive_identity,X,additive_identity)]).

input_clause(multiplicative_identity2,axiom,
    [++product(X,additive_identity,additive_identity)]).

input_clause(product_lemma1,axiom,
    [--product(A,B,C),
     ++product(A,additive_inverse(B),additive_inverse(C))]).

input_clause(product_lemma2,axiom,
    [--product(A,B,C),
     ++product(additive_inverse(A),B,additive_inverse(C))]).

input_clause(product_lemma3,axiom,
    [--product(A,B,C),
     ++product(additive_inverse(A),additive_inverse(B),C)]).

input_clause(b_plus_inverse_c,hypothesis,
    [++sum(b,additive_inverse(c),bS_Ic)]).

input_clause(a_times_b,hypothesis,
    [++product(a,b,aPb)]).

input_clause(a_times_c,hypothesis,
    [++product(a,c,aPc)]).

input_clause(aPb_plus_IaPc,hypothesis,
    [++sum(aPb,additive_inverse(aPc),aPb_S_IaPc)]).

input_clause(prove_a_times_bS_Ic_is_aPb_S__IaPc,theorem,
    [--product(a,bS_Ic,aPb_S_IaPc)]).
%--------------------------------------------------------------------------
