%--------------------------------------------------------------------------
% File     : RNG004=ProdInv-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : X*Y = X^-1*Y^-1
% Version  : [Wos, 1965] axioms : Reduced & Augmented > Incomplete.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Problem 22 [Wos, 1965]
%          : wos22 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   34 (   0 non-Horn)(  12 unit)
%            Number of literals          :   85 (  21 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    8 (   5 constant)
%            Number of variables         :  111 (   2 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include ring theory axioms 
include('Axioms/RNG001-0.ax').
%--------------------------------------------------------------------------
%----Equality axioms for additive operator 
input_clause(additive_inverse_substitution,axiom,
    [--equal(X,Y),
     ++equal(additive_inverse(X),additive_inverse(Y))]).

input_clause(add_substitution1,axiom,
    [--equal(X,Y),
     ++equal(add(X,W),add(Y,W))]).

%----This axiom omited in this version 
%input_clause(add_substitution2,axiom,
%    [--equal(X,Y),
%     ++equal(add(W,X),add(W,Y))]).

input_clause(sum_substitution1,axiom,
    [--equal(X,Y),
     --sum(X,W,Z),
     ++sum(Y,W,Z)]).

input_clause(sum_substitution2,axiom,
    [--equal(X,Y),
     --sum(W,X,Z),
     ++sum(W,Y,Z)]).

input_clause(sum_substitution3,axiom,
    [--equal(X,Y),
     --sum(W,Z,X),
     ++sum(W,Z,Y)]).

%----Equality axioms for multiplicative operator 
input_clause(multiply_substitution1,axiom,
    [--equal(X,Y),
     ++equal(multiply(X,W),multiply(Y,W))]).

%----This axiom omited in this version 
%input_clause(multiply_substitution2,axiom,
%    [--equal(X,Y),
%     ++equal(multiply(W,X),multiply(W,Y))]).

input_clause(product_substitution1,axiom,
    [--equal(X,Y),
     --product(X,W,Z),
     ++product(Y,W,Z)]).

input_clause(product_substitution2,axiom,
    [--equal(X,Y),
     --product(W,X,Z),
     ++product(W,Y,Z)]).

input_clause(product_substitution3,axiom,
    [--equal(X,Y),
     --product(W,Z,X),
     ++product(W,Z,Y)]).

input_clause(multiplicative_identity1,axiom,
    [++product(additive_identity,X,additive_identity)]).

input_clause(multiplicative_identity2,axiom,
    [++product(X,additive_identity,additive_identity)]).

input_clause(a_times_b,hypothesis,
    [++product(a,b,c)]).

input_clause(a_inverse_times_b_inverse,hypothesis,
    [++product(additive_inverse(a),additive_inverse(b),d)]).

input_clause(prove_c_equals_d,theorem,
    [--equal(c,d)]).
%--------------------------------------------------------------------------
