%--------------------------------------------------------------------------
% File     : RNG004=ProdInv-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : X*Y = X^-1*Y^-1
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : R2 [McCharen, et al., 1976]
%          : minuses.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   34 (   0 non-Horn)(  10 unit)
%            Number of literals          :   87 (  25 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    8 (   5 constant)
%            Number of variables         :  115 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include ring theory axioms 
include('Axioms/RNG001-0.ax').
%----Include ring theory equality axioms 
include('Axioms/RNG001-0.eq').
%--------------------------------------------------------------------------
input_clause(a_times_b,hypothesis,
    [++product(a,b,c)]).

input_clause(a_inverse_times_b_inverse,hypothesis,
    [++product(additive_inverse(a),additive_inverse(b),d)]).

input_clause(prove_c_equals_d,theorem,
    [--equal(c,d)]).
%--------------------------------------------------------------------------
