%--------------------------------------------------------------------------
% File     : RNG002=AddRCanc-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : Right cancellation for addition
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Overbeek R., McCharen J., and Wos L. (1976), Complexity and 
%            Related Enhancements for Automated Theorem-Proving Programs, 
%            Computer and Mathematics with Applications 2, 1-16.
% Source   : [McCharen, et al., 1976]
% Names    : Established lemma [McCharen, et al., 1976]
%          : Lemma proved [Overbeek, et al., 1976]

% Status   : 
% Syntax   : Number of clauses           :   34 (   0 non-Horn)(  10 unit)
%            Number of literals          :   87 (  25 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    8 (   5 constant)
%            Number of variables         :  115 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include ring theory axioms 
include('Axioms/RNG001-0.ax').
%----Include ring theory equality axioms 
include('Axioms/RNG001-0.eq').
%--------------------------------------------------------------------------
input_clause(a_plus_b_is_d,hypothesis,
    [++sum(a,b,d)]).

input_clause(a_plus_c_is_d,hypothesis,
    [++sum(a,c,d)]).

input_clause(prove_b_equals_c,theorem,
    [--equal(b,c)]).
%--------------------------------------------------------------------------
