%--------------------------------------------------------------------------
% File     : RNG001=XTimesAId-5 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : X.additive_identity = additive_identity for any X
% Version  : [Wos, 1965] axioms : Reduced > Incomplete.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : Fleisig S., Loveland D.W., Smiley A.K. and Yarmush D.L. 
%            (1974), An Implementation of the Model Elimination Proof 
%            Procedure, Journal of the ACM 21(1), 124-139.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Problem 21 [Wos, 1965]
%          : wos21 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   30 (   0 non-Horn)(   8 unit)
%            Number of literals          :   81 (  20 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    5 (   2 constant)
%            Number of variables         :  109 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : Omits two equality subsitution axioms.
%          : These are the same axioms as in [McCharen, et al., 1976].
%          : I guess this is Example 6c in [Fleisig, et al., 1974].
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include ring theory axioms 
include('Axioms/RNG001-0.ax').
%--------------------------------------------------------------------------
%----Equality axioms for additive operator 
input_clause(additive_inverse_substitution,axiom,
    [--equal(X,Y),
     ++equal(additive_inverse(X),additive_inverse(Y))]).

input_clause(add_substitution1,axiom,
    [--equal(X,Y),
     ++equal(add(X,W),add(Y,W))]).

%----This axiom omited in this version 
%input_clause(add_substitution2,axiom,
%    [--equal(X,Y),
%     ++equal(add(W,X),add(W,Y))]).

input_clause(sum_substitution1,axiom,
    [--equal(X,Y),
     --sum(X,W,Z),
     ++sum(Y,W,Z)]).

input_clause(sum_substitution2,axiom,
    [--equal(X,Y),
     --sum(W,X,Z),
     ++sum(W,Y,Z)]).

input_clause(sum_substitution3,axiom,
    [--equal(X,Y),
     --sum(W,Z,X),
     ++sum(W,Z,Y)]).

%----Equality axioms for multiplicative operator 
input_clause(multiply_substitution1,axiom,
    [--equal(X,Y),
     ++equal(multiply(X,W),multiply(Y,W))]).

%----This axiom omited in this version 
%input_clause(multiply_substitution2,axiom,
%    [--equal(X,Y),
%     ++equal(multiply(W,X),multiply(W,Y))]).

input_clause(product_substitution1,axiom,
    [--equal(X,Y),
     --product(X,W,Z),
     ++product(Y,W,Z)]).

input_clause(product_substitution2,axiom,
    [--equal(X,Y),
     --product(W,X,Z),
     ++product(W,Y,Z)]).

input_clause(product_substitution3,axiom,
    [--equal(X,Y),
     --product(W,Z,X),
     ++product(W,Z,Y)]).

input_clause(prove_multiplicative_identity_axiom,theorem,
    [--product(a,additive_identity,additive_identity)]).
%--------------------------------------------------------------------------
