%--------------------------------------------------------------------------
% File     : RNG001=XTimesAId-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : X.additive_identity = additive_identity for any X
% Version  : [McCharen, et al., 1976] axioms : Augmented.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : R1 [McCharen, et al., 1976]

% Status   : 
% Syntax   : Number of clauses           :   34 (   0 non-Horn)(   8 unit)
%            Number of literals          :   91 (  26 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    5 (   2 constant)
%            Number of variables         :  123 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : Includes left and right cancellation lemmas.
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include ring theory axioms 
include('Axioms/RNG001-0.ax').
%----Include ring theory equality axioms 
include('Axioms/RNG001-0.eq').
%--------------------------------------------------------------------------
input_clause(cancellation1,axiom,
    [--sum(X,Y,Z),
     --sum(X,W,Z),
     ++equal(Y,W)]).

input_clause(cancellation2,axiom,
    [--sum(X,Y,Z),
     --sum(W,Y,Z),
     ++equal(X,W)]).

input_clause(prove_a_times_additive_id_is_additive_id,theorem,
    [--product(a,additive_identity,additive_identity)]).
%--------------------------------------------------------------------------
