%--------------------------------------------------------------------------
% File     : RNG001=XTimesAId-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : X.additive_identity = additive_identity for any X
% Version  : [Fleisig, et al., 1974] axioms : Incomplete.
% English  : 

% Refs     : Fleisig S., Loveland D.W., Smiley A.K. and Yarmush D.L. 
%            (1974), An Implementation of the Model Elimination Proof 
%            Procedure, Journal of the ACM 21(1), 124-139.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Example 6a [Fleisig, et al., 1974]
%          : EX6-T? [Wilson & Minker, 1976]
%          : ex6.lop [SETHEO]
%          : FEX6T1 [SPRFN]
%          : FEX6T2 [SPRFN]

% Status   : 
% Syntax   : Number of clauses           :    8 (   0 non-Horn)(   4 unit)
%            Number of literals          :   22 (   0 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :   30 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
input_clause(additive_identity1,axiom,
    [++sum(additive_identity,X,X)]).

input_clause(additive_inverse1,axiom,
    [++sum(additive_inverse(X),X,additive_identity)]).

input_clause(associativity_of_addition1,axiom,
    [--sum(X,Y,U),
     --sum(Y,Z,V),
     --sum(U,Z,W),
     ++sum(X,V,W)]).

input_clause(associativity_of_addition2,axiom,
    [--sum(X,Y,U),
     --sum(Y,Z,V),
     --sum(X,V,W),
     ++sum(U,Z,W)]).

input_clause(closure_of_multiplication,axiom,
    [++product(X,Y,multiply(X,Y))]).

input_clause(distributivity1,axiom,
    [--product(X,Y,V1),
     --product(X,Z,V2),
     --sum(Y,Z,V3),
     --product(X,V3,V4),
     ++sum(V1,V2,V4)]).

input_clause(distributivity2,axiom,
    [--product(X,Y,V1),
     --product(X,Z,V2),
     --sum(Y,Z,V3),
     --sum(V1,V2,V4),
     ++product(X,V3,V4)]).

input_clause(prove_a_times_additive_id_is_additive_id,theorem,
    [--product(a,additive_identity,additive_identity)]).
%--------------------------------------------------------------------------
