%--------------------------------------------------------------------------
% File     : RNG001=XTimesAId-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Ring Theory
% Problem  : X.additive_identity = additive_identity for any X
% Version  : [Lawrence & Starkey, 1974] axioms : Incomplete.
% English  : 

% Refs     : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : ls37 [Lawrence & Starkey, 1974]
%          : ls37 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   18 (   0 non-Horn)(   7 unit)
%            Number of literals          :   51 (   2 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    5 (   2 constant)
%            Number of variables         :   71 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Don't Include ring theory axioms 
%include('Axioms/RNG001-0.ax').
%--------------------------------------------------------------------------
input_clause(additive_identity1,axiom,
    [++sum(additive_identity,X,X)]).

input_clause(additive_identity2,axiom,
    [++sum(X,additive_identity,X)]).

input_clause(closure_of_multiplication,axiom,
    [++product(X,Y,multiply(X,Y))]).

input_clause(closure_of_addition,axiom,
    [++sum(X,Y,add(X,Y))]).

input_clause(additive_inverse1,axiom,
    [++sum(additive_inverse(X),X,additive_identity)]).

input_clause(additive_inverse2,axiom,
    [++sum(X,additive_inverse(X),additive_identity)]).

input_clause(associativity_of_addition1,axiom,
    [--sum(X,Y,U),
     --sum(Y,Z,V),
     --sum(U,Z,W),
     ++sum(X,V,W)]).

input_clause(associativity_of_addition2,axiom,
    [--sum(X,Y,U),
     --sum(Y,Z,V),
     --sum(X,V,W),
     ++sum(U,Z,W)]).

input_clause(commutativity_of_addition,axiom,
    [--sum(X,Y,Z),
     ++sum(Y,X,Z)]).

input_clause(associativity_of_multiplication1,axiom,
    [--product(X,Y,U),
     --product(Y,Z,V),
     --product(U,Z,W),
     ++product(X,V,W)]).

input_clause(associativity_of_multiplication2,axiom,
    [--product(X,Y,U),
     --product(Y,Z,V),
     --product(X,V,W),
     ++product(U,Z,W)]).

input_clause(distributivity1,axiom,
    [--product(X,Y,V1),
     --product(X,Z,V2),
     --sum(Y,Z,V3),
     --product(X,V3,V4),
     ++sum(V1,V2,V4)]).

input_clause(distributivity2,axiom,
    [--product(X,Y,V1),
     --product(X,Z,V2),
     --sum(Y,Z,V3),
     --sum(V1,V2,V4),
     ++product(X,V3,V4)]).

input_clause(distributivity3,axiom,
    [--product(Y,X,V1),
     --product(Z,X,V2),
     --sum(Y,Z,V3),
     --product(V3,X,V4),
     ++sum(V1,V2,V4)]).

input_clause(distributivity4,axiom,
    [--product(Y,X,V1),
     --product(Z,X,V2),
     --sum(Y,Z,V3),
     --sum(V1,V2,V4),
     ++product(V3,X,V4)]).

%----Equality axioms for operators 
input_clause(addition_is_well_defined,axiom,
    [--sum(X,Y,U),
     --sum(X,Y,V),
     ++equal(U,V)]).

%input_clause(multiplication_is_well_defined,axiom,
%    [--product(X,Y,U),
%     --product(X,Y,V),
%     ++equal(U,V)]).

input_clause(sum_substitution3,axiom,
    [--equal(A,B),
     --sum(C,D,A),
     ++sum(C,D,B)]).

input_clause(theorem,theorem,
    [--product(a,additive_identity,additive_identity)]).
%--------------------------------------------------------------------------
