%--------------------------------------------------------------------------
% File     : PUZ034=NQueens-1.003 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Miscellaneous
% Problem  : N queens problem
% Version  : Theorem formulation : 3 queens.
% English  : The problem is to place N queens on an NxN chess board, 
%            so that no queen can attack another,

% Refs     : 
% Source   : [TPTP]
% Names    : 

% Status   : satisfiable
% Syntax   : Number of clauses           :   18 (   2 non-Horn)(   9 unit)
%            Number of literals          :   39 (   0 equality)
%            Number of predicate symbols :    9 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :   45 (   6 singleton)
%            Maximal clause size         :    7
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
input_clause(make_list_of_numbers1,axiom,
    [++range(Low,High,cons(Low,Rest_of_numbers)),
     --less(Low,High),
     --sum(Low,s(0),New_low),
     --range(New_low,High,Rest_of_numbers)]).

input_clause(make_list_of_numbers2,axiom,
    [++range(Same,Same,cons(Same,empty_list))]).

input_clause(less1,axiom,
    [++less(0,s(X))]).

input_clause(less2,axiom,
    [++less(s(X),s(Y)),
     --less(X,Y)]).

input_clause(add_0,axiom,
    [++sum(X,0,X)]).

input_clause(add,axiom,
    [--sum(X,Y,Z),
     ++sum(X,s(Y),s(Z))]).

input_clause(select1,axiom,
    [++select(Head,cons(Head,Tail),Tail)]).

input_clause(select2,axiom,
    [++select(Element,cons(Head,Tail),cons(Head,New_tail)),
     --select(Element,Tail,New_tail)]).

input_clause(same_definition1,axiom,
    [--same(s(X),0)]).

input_clause(same_definition2,axiom,
    [--same(0,s(X))]).

input_clause(same_definition3,axiom,
    [--same(s(X),s(Y)),
     ++same(X,Y)]).

input_clause(attack,axiom,
    [++diagonal_attack(Queen,s(0),Placed_queens),
     --attack(Queen,Placed_queens)]).

input_clause(check_diagonals1,axiom,
    [--diagonal_attack(Queen,Queen_number,cons(Placed_queen,
Other_placed_queens)),
     --sum(Diagonal1,Queen_number,Placed_queen),
     ++same(Diagonal1,Queen),
     --sum(Placed_queen,Queen_number,Diagonal2),
     ++same(Diagonal2,Queen),
     --sum(Queen_number,s(0),Next_queen_number),
     ++diagonal_attack(Queen,Next_queen_number,Other_placed_queens)]).

input_clause(check_diagonals2,axiom,
    [--diagonal_attack(Queen,Last_queen,empty_list)]).

input_clause(place_a_queen1,axiom,
    [++do_queens(Unplaced_queens,Safe_queens,Placement),
     --select(A_queen,Unplaced_queens,Rest_of_unplaced_queens),
     ++attack(A_queen,Safe_queens),
     --do_queens(Rest_of_unplaced_queens,cons(A_queen,Safe_queens),
Placement)]).

input_clause(place_a_queen2,axiom,
    [++do_queens(empty_list,Placement,Placement)]).

input_clause(set_up_queens,axiom,
    [++queens(Number_of_queens,Placement),
     --sum(Number_of_queens,s(0),Low),
     --sum(Number_of_queens,Number_of_queens,High),
     --range(Low,High,Positions),
     --do_queens(Positions,empty_list,Placement)]).

input_clause(place_queens,theorem,
    [--queens(s(s(s(0))),Placement)]).
%--------------------------------------------------------------------------
